/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.recipe;

import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.compat.emi.ComplicatedBeesEMI;
import com.accbdd.complicated_bees.compat.emi.ingredient.EmiBlock;
import com.accbdd.complicated_bees.compat.emi.ingredient.EmiFlower;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FlowerTypeEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> lookups;
    private final Flower flower;
    private final EmiFlower flowerStack;

    public FlowerTypeEmiRecipe(Flower flower) {
        ResourceLocation flowerId = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(FlowerRegistration.FLOWER_REGISTRY_KEY).m_7981_((Object)flower);
        this.id = ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)("/flower_type/" + flowerId.toString().replace(":", "/")));
        this.flower = flower;
        this.flowerStack = new EmiFlower(flower);
        this.lookups = new ArrayList<EmiIngredient>();
        this.lookups.addAll(flower.getAllFlowerBlocks().stream().map(EmiBlock::new).toList());
    }

    public EmiRecipeCategory getCategory() {
        return ComplicatedBeesEMI.FLOWER_TYPE_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.flowerStack);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.flowerStack);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.lookups;
    }

    public int getDisplayWidth() {
        return 143;
    }

    public int getDisplayHeight() {
        return 40;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)"textures/gui/jei/flower.png"), 0, 0, 143, 40, 0, 0, 143, 40, 143, 40);
        widgets.addText((Component)GeneticHelper.getTranslationKey(this.flower), 45, 20, 0xFFFFFF, true).verticalAlign(TextWidget.Alignment.CENTER).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addSlot(EmiIngredient.of(this.lookups), 116, 11);
    }
}

