/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.recipe;

import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.compat.emi.ComplicatedBeesEMI;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class MutationEmiRecipe
implements EmiRecipe {
    private final Mutation mutation;
    private final ResourceLocation id;
    private final EmiIngredient first;
    private final EmiIngredient second;
    private final EmiIngredient result;
    private final EmiIngredient lookups;

    public MutationEmiRecipe(Mutation mutation) {
        this.mutation = mutation;
        this.id = ResourceLocation.m_214293_((String)"complicated_bees", (String)("/mutation/first/" + mutation.getFirst().toString().replace(":", "/") + "/second/" + mutation.getSecond().toString().replace(":", "/") + "/result/" + mutation.getResult().toString().replace(":", "/")));
        this.first = EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{mutation.getFirstSpecies().toStack((Item)ItemsRegistration.DRONE.get()), mutation.getFirstSpecies().toStack((Item)ItemsRegistration.PRINCESS.get())}));
        this.second = EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{mutation.getSecondSpecies().toStack((Item)ItemsRegistration.PRINCESS.get()), mutation.getSecondSpecies().toStack((Item)ItemsRegistration.DRONE.get())}));
        this.result = EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{mutation.getResultSpecies().toStack((Item)ItemsRegistration.DRONE.get()), mutation.getResultSpecies().toStack((Item)ItemsRegistration.PRINCESS.get())}));
        this.lookups = EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{mutation.getFirstSpecies().toStack((Item)ItemsRegistration.QUEEN.get()), mutation.getSecondSpecies().toStack((Item)ItemsRegistration.QUEEN.get()), mutation.getResultSpecies().toStack((Item)ItemsRegistration.QUEEN.get())}));
    }

    public EmiRecipeCategory getCategory() {
        return ComplicatedBeesEMI.MUTATION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.first, this.second);
    }

    public List<EmiStack> getOutputs() {
        return this.result.getEmiStacks();
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.lookups);
    }

    public int getDisplayWidth() {
        return 143;
    }

    public int getDisplayHeight() {
        return 40;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(ResourceLocation.m_214293_((String)"complicated_bees", (String)"textures/gui/jei/mutations.png"), 0, 0, 143, 40, 0, 0, 143, 40, 143, 40);
        widgets.addSlot(this.first, 11, 11).drawBack(false);
        widgets.addSlot(this.second, 58, 11).drawBack(false);
        widgets.addSlot(this.result, 114, 11).drawBack(false).recipeContext((EmiRecipe)this);
        float chance = this.mutation.getChance() * 100.0f;
        if (BreedingTracker.CLIENT_INSTANCE != null) {
            chance += BreedingTracker.CLIENT_INSTANCE.getResearchedMutations().contains(MutationRegistration.getResourceLocation(this.mutation)) ? ((Float)ServerConfig.SERVER_CONFIG.researchBonus.get()).floatValue() * 100.0f : 0.0f;
        }
        String chanceString = this.mutation.getConditions().isEmpty() ? String.format("%.0f%%", Float.valueOf(chance)) : String.format("[%.0f%%]", Float.valueOf(chance));
        widgets.addText((Component)Component.m_237113_((String)chanceString), 95, 1, -1, true).horizontalAlign(TextWidget.Alignment.CENTER);
        if (!this.mutation.getConditions().isEmpty()) {
            ArrayList<Object> tips = new ArrayList<Object>();
            tips.add(Component.m_237115_((String)"gui.complicated_bees.mutations.has_conditions"));
            for (IMutationCondition condition : this.mutation.getConditions()) {
                tips.add(condition.getDescription());
            }
            widgets.addTooltipText(tips, 81, 1, 25, 9);
        }
    }
}

