/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.jei.ingredient;

import com.accbdd.complicated_bees.ComplicatedBees;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.injection.invoke.arg.ArgumentIndexOutOfBoundsException;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockIngredientRenderer
implements IIngredientRenderer<Block> {
    public static BlockIngredientRenderer INSTANCE = new BlockIngredientRenderer();

    public void render(GuiGraphics guiGraphics, Block ingredient) {
        this.drawBlock(guiGraphics, ingredient);
    }

    private void drawBlock(GuiGraphics guiGraphics, Block block) {
        try {
            ItemStack blockItemStack = new ItemStack((ItemLike)block.m_5456_());
            if (!blockItemStack.m_150930_(Items.f_41852_)) {
                guiGraphics.m_280203_(new ItemStack((ItemLike)block.m_5456_()), 0, 0);
            } else {
                ModelManager manager = Minecraft.m_91087_().m_91304_();
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null) {
                    ResourceLocation loc = ((Registry)level.m_9598_().m_6632_(Registries.f_256747_).orElseThrow()).m_7981_((Object)block);
                    if (loc != null) {
                        TextureAtlasSprite sprite = manager.m_119430_().m_110893_(block.m_49966_()).getParticleIcon(ModelData.EMPTY);
                        guiGraphics.m_280159_(0, 0, 0, 16, 16, sprite);
                    } else {
                        ComplicatedBees.LOGGER.debug("Error parsing block: {} for JEI plugin.", (Object)block.m_49954_().getString());
                    }
                }
            }
        }
        catch (IllegalArgumentException | ArgumentIndexOutOfBoundsException e) {
            ComplicatedBees.LOGGER.error("Block [{}] was handled badly and may not render properly in recipe viewers.", (Object)block.m_49954_().getString());
        }
    }

    public List<Component> getTooltip(Block ingredient, TooltipFlag tooltipFlag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, Block ingredient, TooltipFlag tooltipFlag) {
        tooltip.add((FormattedText)ingredient.m_49954_());
    }
}

