/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.datagen;

import com.accbdd.complicated_bees.block.GyrofugeBlock;
import com.accbdd.complicated_bees.block.MellariumBlock;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "complicated_bees", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)BlocksRegistration.BEE_NEST.get(), (ModelFile)this.createBeeNestModel());
        this.simpleBlock((Block)BlocksRegistration.APIARY.get(), (ModelFile)this.createApiaryModel());
        this.getVariantBuilder((Block)BlocksRegistration.BEE_SORTER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cube("bee_sorter", this.modLoc("block/bee_sorter_down"), this.modLoc("block/bee_sorter_up"), this.modLoc("block/bee_sorter_north"), this.modLoc("block/bee_sorter_south"), this.modLoc("block/bee_sorter_east"), this.modLoc("block/bee_sorter_west"))).texture("particle", this.modLoc("block/bee_sorter_up"))).build());
        this.baseMellariumBlock();
        this.baseGyrofugeBlock();
        this.assembleableBlock(BlocksRegistration.MELLARIUM_TEMP_UNIT, "block/mellarium/mellarium_temp_unit");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_FRAME_HOUSING_1, "block/mellarium/mellarium_frame_housing_1");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_FRAME_HOUSING_2, "block/mellarium/mellarium_frame_housing_2");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_FRAME_HOUSING_3, "block/mellarium/mellarium_frame_housing_3");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_RAIN_SHIELD, "block/mellarium/mellarium_rain_shield");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_MUTATOR, "block/mellarium/mellarium_mutator");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_HYDROREGULATOR, "block/mellarium/mellarium_hydroregulator");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_ENERGY_CELL, "block/mellarium/mellarium_energy_cell");
        this.assembleableBlock(BlocksRegistration.MELLARIUM_OUTPUT_HATCH, "block/mellarium/mellarium_output_hatch");
        this.poweredAssembledBlock(BlocksRegistration.MELLARIUM_SKYBOX, "block/mellarium/mellarium_skybox");
        this.poweredAssembledBlock(BlocksRegistration.MELLARIUM_TEMPORAL_SIMULATOR, "block/mellarium/mellarium_temporal_simulator");
        this.assembleableBlock(BlocksRegistration.GYROFUGE_ENERGY_CELL, "block/gyrofuge/gyrofuge_energy_cell");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_BASIC_PROCESSING_UNIT, "block/gyrofuge/gyrofuge_basic_processing_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_PROCESSING_UNIT, "block/gyrofuge/gyrofuge_processing_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_ADVANCED_PROCESSING_UNIT, "block/gyrofuge/gyrofuge_advanced_processing_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_SPEED_UNIT, "block/gyrofuge/gyrofuge_speed_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_EFFICIENCY_UNIT, "block/gyrofuge/gyrofuge_efficiency_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_EXTRACTION_UNIT, "block/gyrofuge/gyrofuge_extraction_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_BASIC_SPEED_UNIT, "block/gyrofuge/gyrofuge_basic_speed_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_ADVANCED_SPEED_UNIT, "block/gyrofuge/gyrofuge_advanced_speed_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_BASIC_EFFICIENCY_UNIT, "block/gyrofuge/gyrofuge_basic_efficiency_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_ADVANCED_EFFICIENCY_UNIT, "block/gyrofuge/gyrofuge_advanced_efficiency_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_BASIC_EXTRACTION_UNIT, "block/gyrofuge/gyrofuge_basic_extraction_unit");
        this.poweredAssembledBlock(BlocksRegistration.GYROFUGE_ADVANCED_EXTRACTION_UNIT, "block/gyrofuge/gyrofuge_advanced_extraction_unit");
        this.assembleableBlock(BlocksRegistration.GYROFUGE_OUTPUT_HATCH, "block/gyrofuge/gyrofuge_output_hatch");
        this.assembleableBlock(BlocksRegistration.GYROFUGE_INPUT_HATCH, "block/gyrofuge/gyrofuge_input_hatch");
        this.simpleBlock((Block)BlocksRegistration.WAX_BLOCK.get());
        this.horizontalBlock((Block)BlocksRegistration.APID_LIBRARY.get(), (ModelFile)this.createLibraryModel());
        this.stairsBlock((StairBlock)BlocksRegistration.WAX_BLOCK_STAIRS.get(), this.modLoc("block/wax_block"));
        this.slabBlock((SlabBlock)BlocksRegistration.WAX_BLOCK_SLAB.get(), this.modLoc("block/wax_block"), this.modLoc("block/wax_block"));
        this.wallBlock((WallBlock)BlocksRegistration.WAX_BLOCK_WALL.get(), this.modLoc("block/wax_block"));
        this.simpleBlock((Block)BlocksRegistration.SMOOTH_WAX.get());
        this.stairsBlock((StairBlock)BlocksRegistration.SMOOTH_WAX_STAIRS.get(), this.modLoc("block/smooth_wax"));
        this.slabBlock((SlabBlock)BlocksRegistration.SMOOTH_WAX_SLAB.get(), this.modLoc("block/smooth_wax_slab_side"), this.modLoc("block/smooth_wax"));
        this.wallBlock((WallBlock)BlocksRegistration.SMOOTH_WAX_WALL.get(), this.modLoc("block/smooth_wax"));
        this.simpleBlock((Block)BlocksRegistration.WAX_BRICKS.get());
        this.stairsBlock((StairBlock)BlocksRegistration.WAX_BRICK_STAIRS.get(), this.modLoc("block/wax_bricks"));
        this.slabBlock((SlabBlock)BlocksRegistration.WAX_BRICK_SLAB.get(), this.modLoc("block/wax_bricks"), this.modLoc("block/wax_bricks"));
        this.wallBlock((WallBlock)BlocksRegistration.WAX_BRICK_WALL.get(), this.modLoc("block/wax_bricks"));
        this.simpleBlock((Block)BlocksRegistration.CHISELED_WAX.get());
        this.simpleBlock((Block)BlocksRegistration.HONEYED_PLANKS.get());
        this.stairsBlock((StairBlock)BlocksRegistration.HONEYED_STAIRS.get(), this.modLoc("block/honeyed_planks"));
        this.slabBlock((SlabBlock)BlocksRegistration.HONEYED_SLAB.get(), this.modLoc("block/honeyed_planks"), this.modLoc("block/honeyed_planks"));
        this.fenceBlock((FenceBlock)BlocksRegistration.HONEYED_FENCE.get(), this.modLoc("block/honeyed_planks"));
        this.fenceGateBlock((FenceGateBlock)BlocksRegistration.HONEYED_FENCE_GATE.get(), this.modLoc("block/honeyed_planks"));
        this.buttonBlock((ButtonBlock)BlocksRegistration.HONEYED_BUTTON.get(), this.modLoc("block/honeyed_planks"));
        this.pressurePlateBlock((PressurePlateBlock)BlocksRegistration.HONEYED_PRESSURE_PLATE.get(), this.modLoc("block/honeyed_planks"));
        this.doorBlockWithRenderType((DoorBlock)BlocksRegistration.HONEYED_DOOR.get(), this.modLoc("block/honeyed_door_bottom"), this.modLoc("block/honeyed_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)BlocksRegistration.HONEYED_TRAPDOOR.get(), this.modLoc("block/honeyed_trapdoor"), true, "cutout");
        this.signBlock((StandingSignBlock)BlocksRegistration.HONEYED_SIGN.get(), (WallSignBlock)BlocksRegistration.HONEYED_WALL_SIGN.get(), this.modLoc("block/honeyed_planks"));
        this.hangingSignBlock((Block)BlocksRegistration.HONEYED_HANGING_SIGN.get(), (Block)BlocksRegistration.HONEYED_WALL_HANGING_SIGN.get(), this.modLoc("block/honeyed_planks"));
        this.horizontalBlock((Block)BlocksRegistration.MICROSCOPE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/microscope")), -90);
        this.registerCentrifuge();
        this.registerFurnaceGenerator();
        this.registerHoneyGenerator();
        this.directionBlock((Block)BlocksRegistration.AUTOLYZER.get(), (state, builder) -> builder.modelFile((ModelFile)((BlockModelBuilder)this.models().cube("autolyzer", this.modLoc("block/autolyzer_side"), this.modLoc("block/autolyzer_side"), this.modLoc("block/autolyzer_front"), this.modLoc("block/autolyzer_side"), this.modLoc("block/autolyzer_side"), this.modLoc("block/autolyzer_side"))).texture("particle", this.modLoc("block/autolyzer_side"))));
    }

    public void slabBlock(SlabBlock block, ResourceLocation side, ResourceLocation end) {
        this.slabBlock(block, (ModelFile)this.models().slab(this.name((Block)block), side, end, end), (ModelFile)this.models().slabTop(this.name((Block)block) + "_top", side, end, end), (ModelFile)this.models().cubeColumn(this.name((Block)block) + "_double", side, end));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    public BlockModelBuilder createBeeNestModel() {
        String path = "bee_nest";
        ResourceLocation top_texture = this.modLoc("block/bee_nest_top");
        ResourceLocation side_texture = this.modLoc("block/bee_nest_side");
        ResourceLocation bottom_texture = this.modLoc("block/bee_nest_bottom");
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cubeBottomTop(path, side_texture, bottom_texture, top_texture)).element().allFaces((dir, face) -> {
            face.tintindex(1);
            switch (dir) {
                case UP: {
                    face.texture("#top");
                    break;
                }
                case DOWN: {
                    face.texture("#bottom");
                    break;
                }
                default: {
                    face.texture("#side");
                }
            }
        }).end();
    }

    public BlockModelBuilder createApiaryModel() {
        String path = "apiary";
        ResourceLocation side = this.modLoc("block/apiary_side");
        ResourceLocation bottom = this.modLoc("block/apiary_bottom");
        ResourceLocation top = this.modLoc("block/apiary_top");
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube(path, bottom, top, side, side, side, side)).texture("particle", side);
    }

    public BlockModelBuilder createLibraryModel() {
        String path = "apid_library";
        ResourceLocation side = this.modLoc("block/apid_library_side");
        ResourceLocation bottom = this.modLoc("block/apid_library_bottom");
        ResourceLocation top = this.modLoc("block/apid_library_top");
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube(path, bottom, top, side, side, side, side)).texture("particle", side);
    }

    public void registerCentrifuge() {
        String path = "centrifuge";
        ResourceLocation side = this.modLoc("block/centrifuge_side");
        ResourceLocation end = this.modLoc("block/centrifuge_end");
        ResourceLocation front = this.modLoc("block/centrifuge_front");
        ResourceLocation front_on = this.modLoc("block/centrifuge_front_on");
        BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(path, end, end, front, side, side, side)).texture("particle", side);
        BlockModelBuilder modelOn = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(path + "_on", end, end, front_on, side, side, side)).texture("particle", side);
        this.directionBlock((Block)BlocksRegistration.CENTRIFUGE.get(), (state, builder) -> builder.modelFile((ModelFile)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? modelOn : modelOff)));
    }

    public void registerFurnaceGenerator() {
        ResourceLocation BOTTOM = this.modLoc("block/generator_bottom");
        ResourceLocation SIDE = this.modLoc("block/generator_side");
        ResourceLocation TOP = this.modLoc("block/generator_top");
        ResourceLocation BACK = this.modLoc("block/generator_back");
        ResourceLocation FRONT = this.modLoc("block/generator_front");
        ResourceLocation FRONT_ON = this.modLoc("block/generator_front_on");
        BlockModelBuilder modelOn = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(BlocksRegistration.FURNACE_GENERATOR.getId().m_135815_() + "_on", BOTTOM, TOP, FRONT_ON, BACK, SIDE, SIDE)).texture("particle", SIDE);
        BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(BlocksRegistration.FURNACE_GENERATOR.getId().m_135815_(), BOTTOM, TOP, FRONT, BACK, SIDE, SIDE)).texture("particle", SIDE);
        this.directionBlock((Block)BlocksRegistration.FURNACE_GENERATOR.get(), (state, builder) -> builder.modelFile((ModelFile)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? modelOn : modelOff)));
    }

    public void registerHoneyGenerator() {
        ResourceLocation BOTTOM = this.modLoc("block/honey_generator_bottom");
        ResourceLocation SIDE = this.modLoc("block/honey_generator_side");
        ResourceLocation TOP = this.modLoc("block/honey_generator_top");
        ResourceLocation BACK = this.modLoc("block/honey_generator_back");
        ResourceLocation FRONT = this.modLoc("block/honey_generator_front");
        ResourceLocation FRONT_ON = this.modLoc("block/honey_generator_front_on");
        BlockModelBuilder modelOn = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(BlocksRegistration.HONEY_GENERATOR.getId().m_135815_() + "_on", BOTTOM, TOP, FRONT_ON, BACK, SIDE, SIDE)).texture("particle", SIDE);
        BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(BlocksRegistration.HONEY_GENERATOR.getId().m_135815_(), BOTTOM, TOP, FRONT, BACK, SIDE, SIDE)).texture("particle", SIDE);
        this.directionBlock((Block)BlocksRegistration.HONEY_GENERATOR.get(), (state, builder) -> builder.modelFile((ModelFile)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? modelOn : modelOff)));
    }

    private void directionBlock(Block block, BiConsumer<BlockState, ConfiguredModel.Builder<?>> model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.forAllStates(state -> {
            ConfiguredModel.Builder bld = ConfiguredModel.builder();
            model.accept((BlockState)state, (ConfiguredModel.Builder<?>)bld);
            this.applyRotationBld(bld, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
            return bld.build();
        });
    }

    private void poweredAssembledBlock(RegistryObject<? extends Block> block, ResourceLocation tex, ResourceLocation assembledTex, ResourceLocation poweredTex) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        BlockModelBuilder modelUnassembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_(), tex);
        BlockModelBuilder modelAssembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_() + "_assembled", assembledTex);
        BlockModelBuilder modelPowered = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_() + "_powered", poweredTex);
        builder.forAllStates(state -> {
            ConfiguredModel.Builder bld = ConfiguredModel.builder();
            if (((EsotericRegistration.AssembledStatus)((Object)((Object)state.m_61143_(EsotericRegistration.ASSEMBLED)))).equals((Object)EsotericRegistration.AssembledStatus.none)) {
                bld.modelFile((ModelFile)modelUnassembled);
            } else if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                bld.modelFile((ModelFile)modelPowered);
            } else {
                bld.modelFile((ModelFile)modelAssembled);
            }
            return bld.build();
        });
    }

    private void poweredAssembledBlock(RegistryObject<? extends Block> block, String path) {
        this.poweredAssembledBlock(block, this.modLoc(path), this.modLoc(path + "_assembled"), this.modLoc(path + "_powered"));
    }

    private void assembleableBlock(RegistryObject<? extends Block> block, ResourceLocation tex, ResourceLocation assembledTex) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
        BlockModelBuilder modelUnassembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_(), tex);
        BlockModelBuilder modelAssembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_() + "_assembled", assembledTex);
        builder.forAllStates(state -> {
            ConfiguredModel.Builder bld = ConfiguredModel.builder();
            bld.modelFile((ModelFile)(((EsotericRegistration.AssembledStatus)((Object)((Object)state.m_61143_(EsotericRegistration.ASSEMBLED)))).equals((Object)EsotericRegistration.AssembledStatus.none) ? modelUnassembled : modelAssembled));
            return bld.build();
        });
    }

    private void assembleableBlock(RegistryObject<? extends Block> block, String path) {
        this.assembleableBlock(block, this.modLoc(path), this.modLoc(path + "_assembled"));
    }

    private void baseMellariumBlock() {
        List<RegistryObject<MellariumBlock>> blocks = List.of(BlocksRegistration.MELLARIUM_BASE, BlocksRegistration.MELLARIUM_CONTROLLER);
        ResourceLocation tex = this.modLoc("block/mellarium/mellarium_base");
        ResourceLocation assembledTex = this.modLoc("block/mellarium/mellarium_base_assembled");
        ResourceLocation assembledTop = this.modLoc("block/mellarium/mellarium_base_assembled_top");
        ResourceLocation assembledTopSide = this.modLoc("block/mellarium/mellarium_base_assembled_top_side");
        for (RegistryObject<MellariumBlock> block : blocks) {
            BlockModelBuilder modelUnassembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_(), tex);
            BlockModelBuilder modelAssembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_() + "_assembled", assembledTex);
            BlockModelBuilder modelAssembledTop = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(block.getId().m_135815_() + "_assembled_top", assembledTex, assembledTop, assembledTopSide, assembledTopSide, assembledTopSide, assembledTopSide)).texture("particle", assembledTex);
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(state -> {
                ConfiguredModel.Builder bld = ConfiguredModel.builder();
                switch ((EsotericRegistration.AssembledStatus)((Object)((Object)state.m_61143_(EsotericRegistration.ASSEMBLED)))) {
                    case top: {
                        bld.modelFile((ModelFile)modelAssembledTop);
                        break;
                    }
                    case side: {
                        bld.modelFile((ModelFile)modelAssembled);
                        break;
                    }
                    case none: {
                        bld.modelFile((ModelFile)modelUnassembled);
                    }
                }
                return bld.build();
            });
        }
    }

    private void baseGyrofugeBlock() {
        List<RegistryObject<GyrofugeBlock>> blocks = List.of(BlocksRegistration.GYROFUGE_BASE, BlocksRegistration.GYROFUGE_CONTROLLER);
        ResourceLocation tex = this.modLoc("block/gyrofuge/gyrofuge_base");
        ResourceLocation assembledTex = this.modLoc("block/gyrofuge/gyrofuge_base_assembled");
        ResourceLocation assembledTop = this.modLoc("block/gyrofuge/gyrofuge_base_assembled_top");
        ResourceLocation assembledTopSide = this.modLoc("block/gyrofuge/gyrofuge_base_assembled_top_side");
        for (RegistryObject<GyrofugeBlock> block : blocks) {
            BlockModelBuilder modelUnassembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_(), tex);
            BlockModelBuilder modelAssembled = (BlockModelBuilder)this.models().cubeAll(block.getId().m_135815_() + "_assembled", assembledTex);
            BlockModelBuilder modelAssembledTop = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(block.getId().m_135815_() + "_assembled_top", assembledTex, assembledTop, assembledTopSide, assembledTopSide, assembledTopSide, assembledTopSide)).texture("particle", assembledTex);
            VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block.get());
            builder.forAllStates(state -> {
                ConfiguredModel.Builder bld = ConfiguredModel.builder();
                switch ((EsotericRegistration.AssembledStatus)((Object)((Object)state.m_61143_(EsotericRegistration.ASSEMBLED)))) {
                    case top: {
                        bld.modelFile((ModelFile)modelAssembledTop);
                        break;
                    }
                    case side: {
                        bld.modelFile((ModelFile)modelAssembled);
                        break;
                    }
                    case none: {
                        bld.modelFile((ModelFile)modelUnassembled);
                    }
                }
                return bld.build();
            });
        }
    }

    private void applyRotationBld(ConfiguredModel.Builder<?> builder, Direction direction) {
        switch (direction) {
            case DOWN: {
                builder.rotationX(90);
                break;
            }
            case UP: {
                builder.rotationX(-90);
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                builder.rotationY(180);
                break;
            }
            case WEST: {
                builder.rotationY(270);
                break;
            }
            case EAST: {
                builder.rotationY(90);
            }
        }
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    public void simpleBlockItem(Block block, ModelFile model) {
        super.simpleBlockItem(block, model);
    }
}

