/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.datagen.builtin;

import com.accbdd.complicated_bees.bees.Comb;
import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.registry.CombRegistration;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BuiltIn {
    public static final Map<ResourceKey<Comb>, Comb> COMBS = new HashMap<ResourceKey<Comb>, Comb>();
    public static final Map<ResourceKey<Flower>, Flower> FLOWERS = new HashMap<ResourceKey<Flower>, Flower>();
    public static final Map<ResourceKey<Species>, Species> SPECIES = new HashMap<ResourceKey<Species>, Species>();
    public static final Map<ResourceKey<Mutation>, Mutation> MUTATIONS = new HashMap<ResourceKey<Mutation>, Mutation>();

    static Map.Entry<ResourceKey<Comb>, Comb> comb(String path, int outer, int inner) {
        Comb comb = new Comb(outer, inner);
        ResourceKey key = ResourceKey.m_135785_(CombRegistration.COMB_REGISTRY_KEY, (ResourceLocation)BuiltIn.loc(path));
        COMBS.put((ResourceKey<Comb>)key, comb);
        return new AbstractMap.SimpleEntry<ResourceKey<Comb>, Comb>(key, comb);
    }

    static Map.Entry<ResourceKey<Flower>, Flower> flower(String path, List<Block> blocks, List<TagKey<Block>> tags) {
        List<ResourceLocation> blockLocations = blocks.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7981_(arg_0)).toList();
        Flower flower = new Flower(blockLocations, tags);
        ResourceKey key = ResourceKey.m_135785_(FlowerRegistration.FLOWER_REGISTRY_KEY, (ResourceLocation)BuiltIn.loc(path));
        FLOWERS.put((ResourceKey<Flower>)key, flower);
        return new AbstractMap.SimpleEntry<ResourceKey<Flower>, Flower>(key, flower);
    }

    static Map.Entry<ResourceKey<Species>, Species> species(Species.Builder builder) {
        Species species = builder.build();
        ResourceKey key = ResourceKey.m_135785_(SpeciesRegistration.SPECIES_REGISTRY_KEY, (ResourceLocation)species.builderOverride);
        SPECIES.put((ResourceKey<Species>)key, species);
        return new AbstractMap.SimpleEntry<ResourceKey<Species>, Species>(key, species);
    }

    static Map.Entry<ResourceKey<Mutation>, Mutation> mutation(String path, ResourceKey<Species> first, ResourceKey<Species> second, ResourceKey<Species> result, float chance, IMutationCondition ... conditions) {
        Mutation mutation = new Mutation(first.m_135782_(), second.m_135782_(), result.m_135782_(), chance, Arrays.stream(conditions).toList());
        ResourceKey key = ResourceKey.m_135785_(MutationRegistration.MUTATION_REGISTRY_KEY, (ResourceLocation)BuiltIn.loc(path));
        MUTATIONS.put((ResourceKey<Mutation>)key, mutation);
        return new AbstractMap.SimpleEntry<ResourceKey<Mutation>, Mutation>(key, mutation);
    }

    static ResourceLocation loc(String path) {
        return new ResourceLocation("complicated_bees", path);
    }

    static ItemStack stack(Map.Entry<ResourceKey<Comb>, Comb> combEntry) {
        ItemStack stack = new ItemStack((ItemLike)ItemsRegistration.COMB.get(), 1);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("comb_type", combEntry.getKey().m_135782_().toString());
        stack.m_41751_(tag);
        return stack;
    }
}

