/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.datagen.builtin;

import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.bees.mutation.condition.BiomeCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.BlockUnderCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.DimensionCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.NighttimeCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.TemperatureCondition;
import com.accbdd.complicated_bees.datagen.builtin.BuiltIn;
import com.accbdd.complicated_bees.datagen.builtin.BuiltInSpecies;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class Mutations {
    private static final List<Map.Entry<ResourceKey<Species>, Species>> COMMON_MUTATORS = List.of(BuiltInSpecies.FOREST, BuiltInSpecies.PLAINS, BuiltInSpecies.JUNGLE, BuiltInSpecies.DESERT, BuiltInSpecies.ROCKY);
    private static final List<Map.Entry<ResourceKey<Species>, Species>> CULTIVATED_MUTATORS = List.of(BuiltInSpecies.FOREST, BuiltInSpecies.PLAINS);

    public static void generateMutations() {
        for (int i = 0; i < COMMON_MUTATORS.size() - 1; ++i) {
            for (int j = i + 1; j < COMMON_MUTATORS.size(); ++j) {
                Map.Entry<ResourceKey<Species>, Species> first = COMMON_MUTATORS.get(i);
                Map.Entry<ResourceKey<Species>, Species> second = COMMON_MUTATORS.get(j);
                BuiltIn.mutation("apis/" + first.getKey().m_135782_().m_135815_() + "_" + second.getKey().m_135782_().m_135815_() + "_common", first.getKey(), second.getKey(), BuiltInSpecies.COMMON.getKey(), 0.15f, new IMutationCondition[0]);
            }
        }
        for (Map.Entry<ResourceKey<Species>, Species> entry : CULTIVATED_MUTATORS) {
            BuiltIn.mutation("apis/" + entry.getKey().m_135782_().m_135815_() + "_cultivated", entry.getKey(), BuiltInSpecies.COMMON.getKey(), BuiltInSpecies.CULTIVATED.getKey(), 0.12f, new IMutationCondition[0]);
        }
        BuiltIn.mutation("noble/noble", BuiltInSpecies.COMMON.getKey(), BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.NOBLE.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("noble/majestic", BuiltInSpecies.NOBLE.getKey(), BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.MAJESTIC.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("noble/imperial", BuiltInSpecies.MAJESTIC.getKey(), BuiltInSpecies.NOBLE.getKey(), BuiltInSpecies.IMPERIAL.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("desert/outcast", BuiltInSpecies.DESERT.getKey(), BuiltInSpecies.NOBLE.getKey(), BuiltInSpecies.OUTCAST.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("desert/bandit", BuiltInSpecies.OUTCAST.getKey(), BuiltInSpecies.DESERT.getKey(), BuiltInSpecies.BANDIT.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("jungle/tangle", BuiltInSpecies.JUNGLE.getKey(), BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.TANGLE.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("jungle/lush", BuiltInSpecies.TANGLE.getKey(), BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.LUSH.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("ender/surreal", BuiltInSpecies.ENDER.getKey(), BuiltInSpecies.WARPED.getKey(), BuiltInSpecies.SURREAL.getKey(), 0.1f, new DimensionCondition(new ResourceLocation("minecraft:the_end")));
        BuiltIn.mutation("ender/enigmatic", BuiltInSpecies.SURREAL.getKey(), BuiltInSpecies.INTREPID.getKey(), BuiltInSpecies.ENIGMATIC.getKey(), 0.1f, new DimensionCondition(new ResourceLocation("minecraft:the_end")));
        BuiltIn.mutation("heroic/explorer", BuiltInSpecies.JUNGLE.getKey(), BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.EXPLORER.getKey(), 0.12f, new IMutationCondition[0]);
        BuiltIn.mutation("heroic/intrepid", BuiltInSpecies.EXPLORER.getKey(), BuiltInSpecies.DILIGENT.getKey(), BuiltInSpecies.INTREPID.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("heroic/champion", BuiltInSpecies.INTREPID.getKey(), BuiltInSpecies.MAJESTIC.getKey(), BuiltInSpecies.CHAMPION.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("industrious/diligent", BuiltInSpecies.COMMON.getKey(), BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.DILIGENT.getKey(), 0.12f, new IMutationCondition[0]);
        BuiltIn.mutation("industrious/tireless", BuiltInSpecies.DILIGENT.getKey(), BuiltInSpecies.COMMON.getKey(), BuiltInSpecies.TIRELESS.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("industrious/industrious", BuiltInSpecies.TIRELESS.getKey(), BuiltInSpecies.DILIGENT.getKey(), BuiltInSpecies.INDUSTRIOUS.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("infernal/cursed", BuiltInSpecies.CRIMSON.getKey(), BuiltInSpecies.WARPED.getKey(), BuiltInSpecies.CURSED.getKey(), 0.12f, new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("infernal/fiendish", BuiltInSpecies.CURSED.getKey(), BuiltInSpecies.CRIMSON.getKey(), BuiltInSpecies.FIENDISH.getKey(), 0.1f, new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("infernal/devilish", BuiltInSpecies.FIENDISH.getKey(), BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.DEVILISH.getKey(), 0.08f, new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("infernal/infernal", BuiltInSpecies.DEVILISH.getKey(), BuiltInSpecies.BANDIT.getKey(), BuiltInSpecies.INFERNAL.getKey(), 0.08f, new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("infernal/haunted", BuiltInSpecies.CURSED.getKey(), BuiltInSpecies.WARPED.getKey(), BuiltInSpecies.HAUNTED.getKey(), 0.12f, new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH), new BlockUnderCondition(Blocks.f_50135_));
        BuiltIn.mutation("infernal/ghostly", BuiltInSpecies.HAUNTED.getKey(), BuiltInSpecies.TIRELESS.getKey(), BuiltInSpecies.GHOSTLY.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("infernal/spectral", BuiltInSpecies.GHOSTLY.getKey(), BuiltInSpecies.DEVILISH.getKey(), BuiltInSpecies.SPECTRAL.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("metallic/cuprous", BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.DILIGENT.getKey(), BuiltInSpecies.CUPROUS.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_152571_));
        BuiltIn.mutation("metallic/precious", BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.MAJESTIC.getKey(), BuiltInSpecies.PRECIOUS.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50074_));
        BuiltIn.mutation("metallic/ferrous", BuiltInSpecies.CUPROUS.getKey(), BuiltInSpecies.PRECIOUS.getKey(), BuiltInSpecies.FERROUS.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50075_));
        BuiltIn.mutation("metallic/adamantine", BuiltInSpecies.FERROUS.getKey(), BuiltInSpecies.LUMINOUS.getKey(), BuiltInSpecies.ADAMANTINE.getKey(), 0.06f, new BlockUnderCondition(Blocks.f_50721_));
        BuiltIn.mutation("mineral/bituminous", BuiltInSpecies.ROCKY.getKey(), BuiltInSpecies.DESERT.getKey(), BuiltInSpecies.BITUMINOUS.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50353_));
        BuiltIn.mutation("mineral/conductive", BuiltInSpecies.BITUMINOUS.getKey(), BuiltInSpecies.TIRELESS.getKey(), BuiltInSpecies.CONDUCTIVE.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50330_));
        BuiltIn.mutation("mineral/lapic", BuiltInSpecies.BITUMINOUS.getKey(), BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.LAPIC.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50060_));
        BuiltIn.mutation("mineral/amethyst", BuiltInSpecies.CONDUCTIVE.getKey(), BuiltInSpecies.BITUMINOUS.getKey(), BuiltInSpecies.AMETHYST.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_152490_));
        BuiltIn.mutation("mineral/dimantic", BuiltInSpecies.LAPIC.getKey(), BuiltInSpecies.AMETHYST.getKey(), BuiltInSpecies.DIMANTIC.getKey(), 0.06f, new BlockUnderCondition(Blocks.f_50090_));
        BuiltIn.mutation("mineral/emeradic", BuiltInSpecies.AMETHYST.getKey(), BuiltInSpecies.CONDUCTIVE.getKey(), BuiltInSpecies.EMERADIC.getKey(), 0.08f, new BlockUnderCondition(Blocks.f_50268_));
        BuiltIn.mutation("mineral/quartz", BuiltInSpecies.ROCKY.getKey(), BuiltInSpecies.CRIMSON.getKey(), BuiltInSpecies.QUARTZ.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50333_), new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("mineral/luminous", BuiltInSpecies.QUARTZ.getKey(), BuiltInSpecies.HAUNTED.getKey(), BuiltInSpecies.LUMINOUS.getKey(), 0.1f, new BlockUnderCondition(Blocks.f_50141_), new TemperatureCondition(EnumTemperature.HELLISH, EnumTemperature.HELLISH));
        BuiltIn.mutation("necrotic/decaying", BuiltInSpecies.CURSED.getKey(), BuiltInSpecies.OUTCAST.getKey(), BuiltInSpecies.DECAYING.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("necrotic/rotten", BuiltInSpecies.DECAYING.getKey(), BuiltInSpecies.TANGLE.getKey(), BuiltInSpecies.ROTTEN.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("necrotic/necromantic", BuiltInSpecies.ROTTEN.getKey(), BuiltInSpecies.LUSH.getKey(), BuiltInSpecies.NECROMANTIC.getKey(), 0.08f, new NighttimeCondition(), new TemperatureCondition(EnumTemperature.FROZEN, EnumTemperature.COLD));
        BuiltIn.mutation("rocky/robust", BuiltInSpecies.ROCKY.getKey(), BuiltInSpecies.DILIGENT.getKey(), BuiltInSpecies.ROBUST.getKey(), 0.12f, new IMutationCondition[0]);
        BuiltIn.mutation("rocky/resilient", BuiltInSpecies.ROBUST.getKey(), BuiltInSpecies.ROCKY.getKey(), BuiltInSpecies.RESILIENT.getKey(), 0.08f, new IMutationCondition[0]);
        BuiltIn.mutation("creative/jazzy", BuiltInSpecies.CULTIVATED.getKey(), BuiltInSpecies.JUNGLE.getKey(), BuiltInSpecies.JAZZY.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("creative/essayist", BuiltInSpecies.JAZZY.getKey(), BuiltInSpecies.DESERT.getKey(), BuiltInSpecies.ESSAYIST.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("creative/tricky", BuiltInSpecies.FIENDISH.getKey(), BuiltInSpecies.ROTTEN.getKey(), BuiltInSpecies.TRICKY.getKey(), 0.1f, new IMutationCondition[0]);
        BuiltIn.mutation("terraforming/primordial", BuiltInSpecies.ENIGMATIC.getKey(), BuiltInSpecies.NECROMANTIC.getKey(), BuiltInSpecies.PRIMORDIAL.getKey(), 0.08f, new BiomeCondition((TagKey<Biome>)BiomeTags.f_215818_));
        BuiltIn.mutation("terraforming/campestral", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.PLAINS.getKey(), BuiltInSpecies.CAMPESTRAL.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)Tags.Biomes.IS_PLAINS));
        BuiltIn.mutation("terraforming/sylvan", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.FOREST.getKey(), BuiltInSpecies.SYLVAN.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)BiomeTags.f_207611_));
        BuiltIn.mutation("terraforming/boreal", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.COMMON.getKey(), BuiltInSpecies.BOREAL.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)BiomeTags.f_207609_));
        BuiltIn.mutation("terraforming/tropic", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.JUNGLE.getKey(), BuiltInSpecies.TROPIC.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)BiomeTags.f_207610_));
        BuiltIn.mutation("terraforming/paludal", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.DECAYING.getKey(), BuiltInSpecies.PALUDAL.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)Tags.Biomes.IS_SWAMP));
        BuiltIn.mutation("terraforming/gelid", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.NECROMANTIC.getKey(), BuiltInSpecies.GELID.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)Tags.Biomes.IS_SNOWY));
        BuiltIn.mutation("terraforming/mycelic", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.WARPED.getKey(), BuiltInSpecies.MYCELIC.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)Tags.Biomes.IS_MUSHROOM));
        BuiltIn.mutation("terraforming/xeric", BuiltInSpecies.PRIMORDIAL.getKey(), BuiltInSpecies.DESERT.getKey(), BuiltInSpecies.XERIC.getKey(), 0.12f, new BiomeCondition((TagKey<Biome>)Tags.Biomes.IS_DESERT));
    }
}

