/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.multiblock;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.MachineModifier;
import com.accbdd.complicated_bees.block.GyrofugeBlock;
import com.accbdd.complicated_bees.block.entity.CombinedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.gyrofuge.AbstractGyrofugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.AbstractPoweredGyrofugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.GyrofugeControllerBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.GyrofugeEnergyCellBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.IGyrofugeModifier;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.util.BlockPosBoxIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class GyrofugeLogic {
    private final Level level;
    private final BlockPos center;
    private final IEnergyStorage energyStorage;
    private final List<BlockPos> specialBlocks = new ArrayList<BlockPos>();
    private int idleUsage;

    public GyrofugeLogic(Level level, BlockPos center) {
        this.level = level;
        this.center = center;
        BlockPosBoxIterator iterator = new BlockPosBoxIterator(center, 1, 1);
        ArrayList<EnergyStorage> energyStorages = new ArrayList<EnergyStorage>();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractGyrofugeBlockEntity) {
                AbstractGyrofugeBlockEntity gyrofugeBlock = (AbstractGyrofugeBlockEntity)blockEntity;
                gyrofugeBlock.setLogic(this);
                BlockState blockState = level.m_8055_(pos);
                if (!blockState.m_60713_((Block)BlocksRegistration.GYROFUGE_BASE.get())) {
                    this.specialBlocks.add(pos);
                }
                if (gyrofugeBlock instanceof GyrofugeEnergyCellBlockEntity) {
                    GyrofugeEnergyCellBlockEntity cell = (GyrofugeEnergyCellBlockEntity)gyrofugeBlock;
                    energyStorages.add(cell.getEnergy());
                }
                if (!(gyrofugeBlock instanceof AbstractPoweredGyrofugeBlockEntity)) continue;
                AbstractPoweredGyrofugeBlockEntity power = (AbstractPoweredGyrofugeBlockEntity)gyrofugeBlock;
                this.idleUsage += power.getIdleUsage();
                continue;
            }
            if (level.m_7702_(pos) instanceof GyrofugeControllerBlockEntity) continue;
            ComplicatedBees.LOGGER.warn("built a gyrofuge with non-gyrofuge block at {}", (Object)pos);
        }
        this.energyStorage = new CombinedEnergyStorage((IEnergyStorage[])energyStorages.toArray(IEnergyStorage[]::new));
        BlockEntity blockEntity = level.m_7702_(center);
        if (blockEntity instanceof GyrofugeControllerBlockEntity) {
            GyrofugeControllerBlockEntity controller = (GyrofugeControllerBlockEntity)blockEntity;
            controller.setLogic(this);
        }
    }

    public void deconstruct(BlockPos pos) {
        BlockPosBoxIterator iterator = new BlockPosBoxIterator(this.center, 1, 1);
        if (this.getController() != null) {
            while (this.getController() != null && !this.getController().outputBuffer.empty()) {
                Containers.m_18992_((Level)this.level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((ItemStack)this.getController().outputBuffer.pop()));
            }
            IItemHandler handler = (IItemHandler)this.getController().getItemHandler().orElseThrow(() -> new RuntimeException("no item handler found!"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                Containers.m_18992_((Level)this.level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
            }
        }
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            BlockEntity blockEntity = this.level.m_7702_(p);
            if (!(blockEntity instanceof AbstractGyrofugeBlockEntity)) continue;
            AbstractGyrofugeBlockEntity gyrofugeBlock = (AbstractGyrofugeBlockEntity)blockEntity;
            gyrofugeBlock.setLogic(null);
        }
        this.level.m_7731_(this.center, (BlockState)((GyrofugeBlock)((Object)BlocksRegistration.GYROFUGE_BASE.get())).m_49966_().m_61124_(EsotericRegistration.ASSEMBLED, (Comparable)((Object)EsotericRegistration.AssembledStatus.none)), 3);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public GyrofugeControllerBlockEntity getController() {
        BlockEntity blockEntity = this.level.m_7702_(this.center);
        if (blockEntity instanceof GyrofugeControllerBlockEntity) {
            GyrofugeControllerBlockEntity controller = (GyrofugeControllerBlockEntity)blockEntity;
            return controller;
        }
        return null;
    }

    public List<BlockPos> getSpecialBlocks() {
        return this.specialBlocks;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public MachineModifier getMachineModifier() {
        MachineModifier[] machineModifierArray = new MachineModifier[2];
        machineModifierArray[0] = new MachineModifier(1.0f, 1.0f, 1.5f, 0);
        machineModifierArray[1] = MachineModifier.of((MachineModifier[])this.getSpecialBlocks().stream().map(arg_0 -> ((Level)this.level).m_7702_(arg_0)).filter(entity -> entity instanceof IGyrofugeModifier).map(entity -> ((IGyrofugeModifier)entity).getMachineModifier()).toArray(MachineModifier[]::new));
        return MachineModifier.of(machineModifierArray);
    }

    public int getIdleUsage() {
        return this.idleUsage;
    }
}

