/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.network.packet;

import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.IModPacket;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameClientbound;
import com.accbdd.complicated_bees.screen.MicroscopeMenu;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record MicroscopeGameServerbound(byte[] guesses) implements IModPacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130087_(this.guesses);
    }

    public static MicroscopeGameServerbound decode(FriendlyByteBuf buffer) {
        return new MicroscopeGameServerbound(buffer.m_130052_());
    }

    public static void handle(MicroscopeGameServerbound packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            AbstractContainerMenu patt1266$temp = sender.f_36096_;
            if (patt1266$temp instanceof MicroscopeMenu) {
                MicroscopeMenu microscopeMenu = (MicroscopeMenu)patt1266$temp;
                BlockPos pos = microscopeMenu.getPos();
                ServerLevel level = (ServerLevel)sender.m_9236_();
                if (!level.m_7232_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()))) {
                    return;
                }
                byte[] researchCode = microscopeMenu.getResearchCode();
                if (Arrays.equals(packet.guesses, researchCode)) {
                    PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new MicroscopeGameClientbound(MicroscopeGameClientbound.GameState.WON));
                    microscopeMenu.setState(MicroscopeGameClientbound.GameState.WON);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10, 1.0, 1.0, 1.0, 1.0);
                    level.m_247517_((Player)sender, pos, SoundEvents.f_11871_, SoundSource.BLOCKS);
                    microscopeMenu.research();
                } else {
                    if (packet.guesses.length != researchCode.length) {
                        throw new IllegalStateException("recieved a packet of guesses with a different length than code!");
                    }
                    for (int i = 0; i < researchCode.length; ++i) {
                        if (packet.guesses[i] == researchCode[i] || packet.guesses[i] == -1) continue;
                        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new MicroscopeGameClientbound(MicroscopeGameClientbound.GameState.FAILED));
                        microscopeMenu.setState(MicroscopeGameClientbound.GameState.FAILED);
                        microscopeMenu.shuffle();
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10, 1.0, 1.0, 1.0, 1.0);
                        return;
                    }
                    PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new MicroscopeGameClientbound(MicroscopeGameClientbound.GameState.ONGOING));
                    microscopeMenu.setState(MicroscopeGameClientbound.GameState.ONGOING);
                    microscopeMenu.setGuess((byte[])packet.guesses.clone());
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

