/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.recipe;

import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MutatorRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final float mutationModifier;
    public static final RecipeSerializer<MutatorRecipe> SERIALIZER = new RecipeSerializer<MutatorRecipe>(){

        public MutatorRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient input = Ingredient.m_288218_((JsonElement)json.get("input"), (boolean)false);
            float mutationChance = json.get("modifier").getAsFloat();
            return new MutatorRecipe(pRecipeId, input, mutationChance);
        }

        public MutatorRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new MutatorRecipe(pRecipeId, Ingredient.m_43940_((FriendlyByteBuf)pBuffer), pBuffer.readFloat());
        }

        public void toNetwork(FriendlyByteBuf pBuffer, MutatorRecipe pRecipe) {
            pRecipe.getInput().m_43923_(pBuffer);
            pBuffer.writeFloat(pRecipe.mutationModifier);
        }
    };

    public MutatorRecipe(ResourceLocation id, Ingredient input, float mutationModifier) {
        this.id = id;
        this.input = input;
        this.mutationModifier = mutationModifier;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EsotericRegistration.MUTATOR_RECIPE.get();
    }

    public float getMutationModifier() {
        return this.mutationModifier;
    }

    public Ingredient getInput() {
        return this.input;
    }
}

