/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.registry;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.BiomeCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.BlockTagUnderCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.BlockUnderCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.DaytimeCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.DimensionCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.DownfallCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.EcstaticCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.HumidityCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.NighttimeCondition;
import com.accbdd.complicated_bees.bees.mutation.condition.TemperatureCondition;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryBuilder;

public class MutationRegistration {
    public static final ResourceKey<Registry<Mutation>> MUTATION_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("complicated_bees", "mutation"));
    public static final ResourceLocation MUTATION_CONDITION_KEY = new ResourceLocation("complicated_bees", "mutation_condition");
    public static final RegistryBuilder<IMutationCondition> MUTATION_CONDITION_REGISTRY = RegistryBuilder.of((ResourceLocation)MUTATION_CONDITION_KEY);
    public static final DeferredRegister<IMutationCondition> MUTATION_CONDITIONS = DeferredRegister.create((ResourceLocation)MUTATION_CONDITION_KEY, (String)"complicated_bees");
    public static final Supplier<IMutationCondition> BLOCK_UNDER = MUTATION_CONDITIONS.register(BlockUnderCondition.ID, () -> new BlockUnderCondition(Blocks.f_50016_));
    public static final Supplier<IMutationCondition> ECSTATIC = MUTATION_CONDITIONS.register(EcstaticCondition.ID, EcstaticCondition::new);
    public static final Supplier<IMutationCondition> DAYTIME = MUTATION_CONDITIONS.register(DaytimeCondition.ID, DaytimeCondition::new);
    public static final Supplier<IMutationCondition> NIGHTTIME = MUTATION_CONDITIONS.register(NighttimeCondition.ID, NighttimeCondition::new);
    public static final Supplier<IMutationCondition> DOWNFALL = MUTATION_CONDITIONS.register(DownfallCondition.ID, DownfallCondition::new);
    public static final Supplier<IMutationCondition> HUMIDITY = MUTATION_CONDITIONS.register(HumidityCondition.ID, () -> new HumidityCondition(EnumHumidity.NORMAL, EnumHumidity.NORMAL));
    public static final Supplier<IMutationCondition> TEMPERATURE = MUTATION_CONDITIONS.register(TemperatureCondition.ID, () -> new TemperatureCondition(EnumTemperature.NORMAL, EnumTemperature.NORMAL));
    public static final Supplier<IMutationCondition> DIMENSION = MUTATION_CONDITIONS.register(DimensionCondition.ID, () -> new DimensionCondition(new ResourceLocation("minecraft:overworld")));
    public static final Supplier<IMutationCondition> BIOME = MUTATION_CONDITIONS.register("biome", () -> new BiomeCondition((ResourceKey<Biome>)Biomes.f_48202_));
    public static final Supplier<IMutationCondition> BLOCK_TAG_UNDER = MUTATION_CONDITIONS.register(BlockTagUnderCondition.ID, () -> new BlockTagUnderCondition((TagKey<Block>)BlockTags.f_144274_));

    public static ResourceLocation getResourceLocation(Mutation mutation) {
        return ((Registry)GeneticHelper.getRegistryAccess().m_6632_(MUTATION_REGISTRY_KEY).get()).m_7981_((Object)mutation);
    }

    public static Mutation getFromResourceLocation(ResourceLocation loc) {
        return (Mutation)((Registry)GeneticHelper.getRegistryAccess().m_6632_(MUTATION_REGISTRY_KEY).get()).m_7745_(loc);
    }
}

