/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.registry;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SpeciesRegistration {
    public static final ResourceKey<Registry<Species>> SPECIES_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("complicated_bees", "species"));
    private static final Map<ResourceLocation, Integer> complexities = new HashMap<ResourceLocation, Integer>();

    @Nullable
    public static Species getFromResourceLocation(@Nullable ResourceLocation resourceLocation) {
        return (Species)((Registry)GeneticHelper.getRegistryAccess().m_6632_(SPECIES_REGISTRY_KEY).get()).m_7745_(resourceLocation);
    }

    public static ResourceLocation getResourceLocation(Species species) {
        if (species == null || species.equals(Species.INVALID)) {
            return new ResourceLocation("complicated_bees:invalid");
        }
        return ((Registry)GeneticHelper.getRegistryAccess().m_6632_(SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species);
    }

    public static int getComplexity(Species species) {
        ResourceLocation loc = SpeciesRegistration.getResourceLocation(species);
        if (complexities.containsKey(loc)) {
            return complexities.get(loc);
        }
        return SpeciesRegistration.calculateComplexity(loc);
    }

    public static int calculateComplexity(ResourceLocation species) {
        if (complexities.containsKey(species)) {
            return complexities.get(species);
        }
        HashSet<Mutation> visited = new HashSet<Mutation>();
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        return SpeciesRegistration.calculateComplexity(species, visited, (Registry<Mutation>)((Registry)registryAccess.m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get()));
    }

    public static int calculateComplexity(ResourceLocation species, Set<Mutation> visited, Registry<Mutation> mutationRegistry) {
        List<Mutation> x = mutationRegistry.m_123024_().filter(mutation -> mutation.getResult().equals((Object)species) && !visited.contains(mutation)).toList();
        if (x.isEmpty()) {
            return complexities.getOrDefault(species, 1);
        }
        x.forEach(mutation -> {
            visited.add((Mutation)mutation);
            complexities.put(species, Math.min(Math.max(SpeciesRegistration.calculateComplexity(mutation.getFirst(), visited, mutationRegistry), SpeciesRegistration.calculateComplexity(mutation.getSecond(), visited, mutationRegistry)) + 1, complexities.getOrDefault(species, Integer.MAX_VALUE)));
        });
        return complexities.get(species);
    }
}

