/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen;

import com.accbdd.complicated_bees.bees.MachineModifier;
import com.accbdd.complicated_bees.block.entity.BaseGeneratorBlockEntity;
import com.accbdd.complicated_bees.item.UpgradeItem;
import com.accbdd.complicated_bees.screen.AbstractBaseInventoryMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractGeneratorMenu
extends AbstractBaseInventoryMenu {
    private final BlockPos pos;
    private final Block block;
    private int power;
    private int burnTime;
    private int maxBurnTime;
    private int generate;
    private List<Slot> upgradeSlots;
    private static final int INV_X = 8;
    private static final int INV_Y = 76;

    public AbstractGeneratorMenu(MenuType<?> type, int windowId, Player player, BlockPos pos, Block block) {
        super(type, windowId, player, 4, 8, 76);
        this.pos = pos;
        this.block = block;
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof BaseGeneratorBlockEntity) {
            final BaseGeneratorBlockEntity generator = (BaseGeneratorBlockEntity)blockEntity;
            this.upgradeSlots = new ArrayList<Slot>();
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)generator.getItems(), 0, 80, 40));
            for (int i = 0; i < 3; ++i) {
                this.upgradeSlots.add(this.m_38897_((Slot)new SlotItemHandler((IItemHandler)generator.getUpgradeItemHandler().resolve().get(), i, 145, 8 + i * 18)));
            }
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return generator.getStoredPower() & 0xFFFF;
                }

                public void m_6422_(int pValue) {
                    AbstractGeneratorMenu.this.power = AbstractGeneratorMenu.this.power & 0xFFFF0000 | pValue & 0xFFFF;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return generator.getStoredPower() >> 16 & 0xFFFF;
                }

                public void m_6422_(int pValue) {
                    AbstractGeneratorMenu.this.power = AbstractGeneratorMenu.this.power & 0xFFFF | (pValue & 0xFFFF) << 16;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return generator.getCurrentBurnTime();
                }

                public void m_6422_(int pValue) {
                    AbstractGeneratorMenu.this.burnTime = pValue;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return generator.getMaxBurnTime();
                }

                public void m_6422_(int pValue) {
                    AbstractGeneratorMenu.this.maxBurnTime = pValue;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return generator.getGenerate();
                }

                public void m_6422_(int pValue) {
                    AbstractGeneratorMenu.this.generate = pValue;
                }
            });
        }
        this.layoutPlayerInventorySlots((Container)player.m_150109_());
    }

    public int getPower() {
        return this.power;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public int getPowerPerTick() {
        return this.generate;
    }

    public List<Component> getUpgradeTooltip() {
        return MachineModifier.of((MachineModifier[])this.upgradeSlots.stream().map(slot -> {
            Item patt4341$temp;
            if (slot.m_6657_() && (patt4341$temp = slot.m_7993_().m_41720_()) instanceof UpgradeItem) {
                UpgradeItem upgrade = (UpgradeItem)patt4341$temp;
                return upgrade.getModifier();
            }
            return MachineModifier.BLANK;
        }).toArray(MachineModifier[]::new)).getTooltipComponents();
    }

    public boolean m_6875_(Player player) {
        return AbstractGeneratorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.pos), (Player)player, (Block)this.block);
    }
}

