/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen;

import com.accbdd.complicated_bees.block.entity.ApiaryBlockEntity;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MenuRegistration;
import com.accbdd.complicated_bees.screen.AbstractBaseInventoryMenu;
import com.accbdd.complicated_bees.screen.slot.ItemSlot;
import com.accbdd.complicated_bees.screen.slot.OutputSlot;
import com.accbdd.complicated_bees.screen.slot.TagSlot;
import com.accbdd.complicated_bees.util.enums.EnumErrorCodes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class ApiaryMenu
extends AbstractBaseInventoryMenu {
    private final BlockPos pos;
    private final ContainerData data;
    private static final int INV_X = 8;
    private static final int INV_Y = 105;

    public ApiaryMenu(int windowId, Player player, BlockPos pos) {
        this(windowId, player, pos, (ContainerData)new SimpleContainerData(3));
    }

    public ApiaryMenu(int windowId, Player player, BlockPos pos, ContainerData data) {
        super(MenuRegistration.APIARY_MENU.get(), windowId, player, 12, 8, 105);
        this.data = data;
        this.pos = pos;
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ApiaryBlockEntity) {
            ApiaryBlockEntity apiary = (ApiaryBlockEntity)blockEntity;
            this.m_38897_((Slot)new TagSlot((IItemHandler)apiary.getBeeItems(), 0, 29, 38, ItemTagGenerator.ROYAL));
            this.m_38897_((Slot)new ItemSlot((IItemHandler)apiary.getBeeItems(), 1, 29, 63, (Item)ItemsRegistration.DRONE.get()));
            this.m_38897_((Slot)new TagSlot((IItemHandler)apiary.getFrameItems(), 0, 65, 23, ItemTagGenerator.FRAME));
            this.m_38897_((Slot)new TagSlot((IItemHandler)apiary.getFrameItems(), 1, 65, 51, ItemTagGenerator.FRAME));
            this.m_38897_((Slot)new TagSlot((IItemHandler)apiary.getFrameItems(), 2, 65, 79, ItemTagGenerator.FRAME));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 0, 115, 51));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 1, 115, 26));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 2, 137, 39));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 3, 137, 64));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 4, 115, 76));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 5, 93, 64));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)apiary.getOutputItems(), 6, 93, 39));
        }
        this.layoutPlayerInventorySlots((Container)player.m_150109_());
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return ApiaryMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.pos), (Player)player, (Block)((Block)BlocksRegistration.APIARY.get()));
    }

    public boolean hasQueen() {
        ItemStack item = this.m_38853_(0).m_7993_();
        return item.m_41720_() == ItemsRegistration.QUEEN.get();
    }

    public int getScaledProgress(float progress, int maxProgress) {
        int barHeight = 45;
        return maxProgress != 0 && progress != 0.0f ? (int)(progress * (float)barHeight / (float)maxProgress) : 0;
    }

    public ItemStack getQueen() {
        return this.m_38853_(0).m_7993_();
    }

    public boolean isBreeding() {
        return this.data.m_6413_(0) > 0;
    }

    public ContainerData getData() {
        return this.data;
    }

    public boolean hasQueue() {
        return this.data.m_6413_(2) == EnumErrorCodes.OUTPUT_FULL.value;
    }
}

