/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.bees.Chromosome;
import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.IBeeHousing;
import com.accbdd.complicated_bees.bees.gene.GeneActiveTime;
import com.accbdd.complicated_bees.bees.gene.GeneFlower;
import com.accbdd.complicated_bees.bees.gene.GeneHumidity;
import com.accbdd.complicated_bees.bees.gene.GeneTemperature;
import com.accbdd.complicated_bees.bees.gene.GeneTerritory;
import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.util.BlockPosBoxIterator;
import com.accbdd.complicated_bees.util.Util;
import com.accbdd.complicated_bees.util.enums.EnumErrorCodes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BeeLogic {
    private Level level;
    private BlockPos pos;
    private final IBeeHousing housing;
    private boolean queenSatisfied;
    private boolean queenEcstatic;
    private EnumTemperature temperatureCache = null;
    private EnumHumidity humidityCache = null;
    private final List<BlockPos> flowerCache = new ArrayList<BlockPos>();
    private ItemStack queen;

    public BeeLogic(Level level, BlockPos pos, IBeeHousing housing) {
        this.level = level;
        this.pos = pos;
        this.housing = housing;
    }

    public void clearConditionCache() {
        this.temperatureCache = null;
        this.humidityCache = null;
    }

    public ItemStack getQueen() {
        return this.queen;
    }

    public void setQueen(ItemStack queen) {
        this.queen = queen;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    private void checkQueenSatisfied() {
        this.clearConditionCache();
        if (!(this.getQueen().m_41720_() instanceof QueenItem)) {
            this.queenSatisfied = false;
            return;
        }
        if (this.level == null) {
            this.queenSatisfied = false;
            return;
        }
        Chromosome chromosome = GeneticHelper.getChromosome(this.getQueen(), true);
        if (!((GeneTemperature)chromosome.getGene(GeneTemperature.ID)).withinTolerance(this.getTemperature())) {
            this.addError(EnumErrorCodes.WRONG_TEMP);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.WRONG_TEMP);
        if (!((GeneHumidity)chromosome.getGene(GeneHumidity.ID)).withinTolerance(this.getHumidity())) {
            this.addError(EnumErrorCodes.WRONG_HUMIDITY);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.WRONG_HUMIDITY);
        if (this.flowerCache.isEmpty()) {
            this.addError(EnumErrorCodes.NO_FLOWER);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.NO_FLOWER);
        if (!this.checkRainOverride() && !((Boolean)chromosome.getGene(new ResourceLocation("complicated_bees", "weatherproof")).get()).booleanValue()) {
            this.addError(EnumErrorCodes.WEATHER);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.WEATHER);
        if (!this.checkSky() && !((Boolean)chromosome.getGene(new ResourceLocation("complicated_bees", "cave_dwelling")).get()).booleanValue()) {
            this.addError(EnumErrorCodes.UNDERGROUND);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.UNDERGROUND);
        if (!((GeneActiveTime)chromosome.getGene(new ResourceLocation("complicated_bees", "active_time"))).isSatisfied(this.level)) {
            this.addError(EnumErrorCodes.WRONG_TIME);
            this.queenSatisfied = false;
            return;
        }
        this.removeError(EnumErrorCodes.WRONG_TIME);
        this.queenSatisfied = true;
    }

    private void checkQueenEcstatic() {
        Chromosome chromosome = GeneticHelper.getChromosome(this.getQueen(), true);
        if (((EnumTemperature)((Object)((GeneTemperature)chromosome.getGene(GeneTemperature.ID)).get())).equals((Object)this.getTemperature()) && ((EnumHumidity)((Object)((GeneHumidity)chromosome.getGene(GeneHumidity.ID)).get())).equals((Object)this.getHumidity()) && this.queenSatisfied) {
            this.addError(EnumErrorCodes.ECSTATIC);
            this.queenEcstatic = true;
        } else {
            this.removeError(EnumErrorCodes.ECSTATIC);
            this.queenEcstatic = false;
        }
    }

    public void checkConditions() {
        if (!this.getLevel().f_46443_) {
            this.checkFlowerCache();
            this.checkQueenSatisfied();
            this.checkQueenEcstatic();
        }
    }

    private boolean checkRainOverride() {
        boolean clear = !this.getLevel().m_46758_(this.getPos().m_7494_());
        BlockPosBoxIterator it = this.getTerritoryIterator();
        while (it.hasNext()) {
            BlockPos checkPos = (BlockPos)it.next();
            if (!this.getLevel().m_46749_(checkPos) || !this.getLevel().m_46758_(checkPos.m_7494_())) continue;
            clear = false;
            break;
        }
        if (clear) {
            return true;
        }
        for (BeeHousingModifier mod : this.housing.getHousingModifiers()) {
            if (!mod.getRainOverride()) continue;
            return true;
        }
        return false;
    }

    private boolean checkSky() {
        boolean sky = Util.canSeeSky(this.getLevel(), this.getPos().m_7494_());
        if (sky) {
            return true;
        }
        for (BeeHousingModifier mod : this.housing.getHousingModifiers()) {
            if (!mod.getSkyOverride()) continue;
            return true;
        }
        return false;
    }

    public boolean isQueenSatisfied() {
        return this.queenSatisfied;
    }

    public boolean isQueenEcstatic() {
        return this.queenEcstatic;
    }

    public EnumHumidity getHumidity() {
        if (this.humidityCache == null) {
            if (this.getLevel() == null) {
                return null;
            }
            this.humidityCache = EnumHumidity.getFromPosition(this.getLevel(), this.getPos());
            for (BeeHousingModifier mod : this.housing.getHousingModifiers()) {
                int ordinal = this.humidityCache.ordinal() + mod.getHumidityMod().up - mod.getHumidityMod().down;
                this.humidityCache = EnumHumidity.values()[Math.max(0, Math.min(EnumHumidity.values().length - 1, ordinal))];
            }
        }
        return this.humidityCache;
    }

    public EnumTemperature getTemperature() {
        if (this.temperatureCache == null) {
            if (this.getLevel() == null) {
                return null;
            }
            this.temperatureCache = EnumTemperature.getFromPosition(this.getLevel(), this.getPos());
            for (BeeHousingModifier mod : this.housing.getHousingModifiers()) {
                int ordinal = this.temperatureCache.ordinal() + mod.getTemperatureMod().up - mod.getTemperatureMod().down;
                this.temperatureCache = EnumTemperature.values()[Math.max(0, Math.min(EnumTemperature.values().length - 1, ordinal))];
            }
        }
        return this.temperatureCache;
    }

    private void checkFlowerCache() {
        Flower flower = (Flower)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).get()).m_7745_((ResourceLocation)((GeneFlower)GeneticHelper.getGene(this.getQueen(), GeneFlower.ID, true)).get());
        Level level = this.getLevel();
        if (flower == null || level == null) {
            this.flowerCache.clear();
            this.flowerCache.add(this.getPos());
            return;
        }
        for (int i = 0; i < this.flowerCache.size(); ++i) {
            if (flower.isAcceptable(level.m_8055_(this.flowerCache.get(i)))) {
                return;
            }
            this.flowerCache.remove(i);
            --i;
        }
        this.rebuildFlowerCache();
    }

    public void rebuildFlowerCache() {
        this.clearFlowerCache();
        Flower flower = (Flower)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).get()).m_7745_((ResourceLocation)((GeneFlower)GeneticHelper.getGene(this.getQueen(), GeneFlower.ID, true)).get());
        if (flower == null) {
            this.flowerCache.add(this.getPos());
            return;
        }
        BlockPosBoxIterator it = this.getTerritoryIterator();
        while (it.hasNext() && this.getQueen().m_150930_((Item)ItemsRegistration.QUEEN.get())) {
            BlockPos pos = (BlockPos)it.next();
            if (!flower.isAcceptable(this.getLevel().m_8055_(pos))) continue;
            this.flowerCache.add(pos);
        }
    }

    public void clearFlowerCache() {
        this.flowerCache.clear();
    }

    BlockPosBoxIterator getTerritoryIterator() {
        float rangeModifier = 1.0f;
        for (BeeHousingModifier modifier : this.housing.getHousingModifiers()) {
            rangeModifier *= modifier.getTerritoryMod();
        }
        int[] searchRadii = (int[])GeneticHelper.getGeneValue(this.getQueen(), GeneTerritory.ID, true);
        return new BlockPosBoxIterator(this.getPos(), Math.round((float)searchRadii[0] * rangeModifier), Math.round((float)searchRadii[1] * rangeModifier));
    }

    private void addError(EnumErrorCodes ... error) {
        this.housing.addError(error);
    }

    private void removeError(EnumErrorCodes ... error) {
        this.housing.removeError(error);
    }
}

