/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Flower {
    private final Set<Block> flowerBlocks = new HashSet<Block>();
    private final Set<TagKey<Block>> flowerTags = new HashSet<TagKey<Block>>();
    public static final Flower INVALID = new Flower(new ArrayList<ResourceLocation>(), new ArrayList<TagKey<Block>>());

    public Flower(List<ResourceLocation> blocks, List<TagKey<Block>> tags) {
        for (ResourceLocation block : blocks) {
            this.flowerBlocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(block));
        }
        this.flowerTags.addAll(tags);
    }

    public boolean isAcceptable(BlockState block) {
        return this.flowerBlocks.contains(block.m_60734_()) || this.withinTags(block);
    }

    private boolean withinTags(BlockState block) {
        boolean within = false;
        for (TagKey<Block> blockTagKey : this.flowerTags) {
            within = block.m_204336_(blockTagKey) || within;
        }
        return within;
    }

    public List<ResourceLocation> getBlocksAsResourceLocs() {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (Block block : this.flowerBlocks) {
            result.add(BuiltInRegistries.f_256975_.m_7981_((Object)block));
        }
        return result;
    }

    public List<TagKey<Block>> getTags() {
        return this.flowerTags.stream().toList();
    }
}

