/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class Product {
    public static final Codec<Product> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(bp -> bp.getStack().m_41720_()), (App)ExtraCodecs.f_144629_.optionalFieldOf("count", (Object)1).forGetter(bp -> bp.getStack().m_41613_()), (App)CompoundTag.f_128325_.optionalFieldOf("nbt", (Object)new CompoundTag()).forGetter(bp -> bp.getStack().m_41784_()), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Product::getChance)).apply((Applicative)instance, (item, ct, nbt, chance) -> {
        ItemStack stack = new ItemStack((ItemLike)item, ct.intValue());
        if (!Objects.equals(nbt, new CompoundTag())) {
            stack.m_41751_(nbt);
        }
        return new Product(stack, chance.floatValue());
    }));
    public static final List<Product> EMPTY = List.of(new Product(Items.f_41852_.m_7968_(), 0.0f));
    public static final Random rand = new Random();
    private final ItemStack stack;
    private final float chance;

    public Product(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getStack() {
        return this.stack.m_41777_();
    }

    public ItemStack getStackResult(float ... modifiers) {
        ItemStack stack;
        float stackChance = this.getChance();
        for (float modifier : modifiers) {
            stackChance *= modifier;
        }
        if (stackChance > 1.0f) {
            stack = this.getStack();
            stack.m_41764_((int)stackChance * stack.m_41613_());
            stack.m_41769_(rand.nextFloat() < stackChance - (float)((int)stackChance) ? this.getStack().m_41613_() : 0);
        } else {
            stack = rand.nextFloat() < stackChance ? this.getStack() : ItemStack.f_41583_;
        }
        return stack;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeFloat(this.chance);
        buf.m_130055_(this.stack);
    }

    public static Product fromNetwork(FriendlyByteBuf buf) {
        float chance = buf.readFloat();
        ItemStack item = buf.m_130267_();
        return new Product(item, chance);
    }
}

