/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.mutation.condition;

import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.mutation.condition.MutationCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class HumidityCondition
extends MutationCondition {
    public static String ID = "humidity";
    EnumHumidity humidityMin;
    EnumHumidity humidityMax;

    public HumidityCondition(EnumHumidity humidityMin, EnumHumidity humidityMax) {
        this.humidityMin = humidityMin;
        this.humidityMax = humidityMax;
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("complicated_bees", ID);
    }

    @Override
    public boolean check(Level level, BlockPos pos) {
        EnumHumidity checkedHumidity = EnumHumidity.getFromPosition(level, pos);
        return checkedHumidity.ordinal() >= this.humidityMin.ordinal() && checkedHumidity.ordinal() <= this.humidityMax.ordinal();
    }

    @Override
    public Component getDescription() {
        if (this.humidityMax.equals((Object)this.humidityMin)) {
            return Component.m_237110_((String)"gui.complicated_bees.mutations.humidity", (Object[])new Object[]{this.humidityMin.getTranslationKey()});
        }
        return Component.m_237110_((String)"gui.complicated_bees.mutations.humidity_range", (Object[])new Object[]{this.humidityMin.getTranslationKey(), this.humidityMax.getTranslationKey()});
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("min", (Tag)StringTag.m_129297_((String)this.humidityMin.toString()));
        tag.m_128365_("max", (Tag)StringTag.m_129297_((String)this.humidityMax.toString()));
        return tag;
    }

    @Override
    public HumidityCondition deserialize(CompoundTag tag) {
        return new HumidityCondition(EnumHumidity.getFromString(tag.m_128461_("min")), EnumHumidity.getFromString(tag.m_128461_("max")));
    }
}

