/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.mutation.condition;

import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.bees.mutation.condition.MutationCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TemperatureCondition
extends MutationCondition {
    public static String ID = "temperature";
    EnumTemperature tempMin;
    EnumTemperature tempMax;

    public TemperatureCondition(EnumTemperature tempMin, EnumTemperature tempMax) {
        this.tempMin = tempMin;
        this.tempMax = tempMax;
    }

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("complicated_bees", ID);
    }

    @Override
    public boolean check(Level level, BlockPos pos) {
        EnumTemperature checkedTemp = EnumTemperature.getFromPosition(level, pos);
        return checkedTemp.ordinal() >= this.tempMin.ordinal() && checkedTemp.ordinal() <= this.tempMax.ordinal();
    }

    @Override
    public Component getDescription() {
        if (this.tempMax.equals((Object)this.tempMin)) {
            return Component.m_237110_((String)"gui.complicated_bees.mutations.temperature", (Object[])new Object[]{this.tempMin.getTranslationKey()});
        }
        return Component.m_237110_((String)"gui.complicated_bees.mutations.temperature_range", (Object[])new Object[]{this.tempMin.getTranslationKey(), this.tempMax.getTranslationKey()});
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("min", (Tag)StringTag.m_129297_((String)this.tempMin.toString()));
        tag.m_128365_("max", (Tag)StringTag.m_129297_((String)this.tempMax.toString()));
        return tag;
    }

    @Override
    public TemperatureCondition deserialize(CompoundTag tag) {
        return new TemperatureCondition(EnumTemperature.getFromString(tag.m_128461_("min")), EnumTemperature.getFromString(tag.m_128461_("max")));
    }
}

