/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.tracking;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.tracking.IBreedingTracker;
import com.accbdd.complicated_bees.client.DiscoverToast;
import com.accbdd.complicated_bees.client.ResearchToast;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.TrackerSyncClientbound;
import com.accbdd.complicated_bees.network.packet.TrackerUpdateClientbound;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BreedingTracker
extends SavedData
implements IBreedingTracker {
    public static BreedingTracker CLIENT_INSTANCE;
    public static String UUID_KEY;
    public static String SPECIES_KEY;
    public static String MUTATIONS_KEY;
    public static String RESEARCH_KEY;
    private final UUID playerId;
    protected final Set<ResourceLocation> discoveredSpecies;
    protected final Set<ResourceLocation> discoveredMutations;
    protected final Set<ResourceLocation> researchedMutations;

    public BreedingTracker(UUID playerId) {
        this.playerId = playerId;
        this.discoveredSpecies = new HashSet<ResourceLocation>();
        this.discoveredMutations = new HashSet<ResourceLocation>();
        this.researchedMutations = new HashSet<ResourceLocation>();
    }

    @Override
    public UUID getUUID() {
        return this.playerId;
    }

    public Set<ResourceLocation> getDiscoveredSpecies() {
        return this.discoveredSpecies;
    }

    @Override
    public Collection<ResourceLocation> getDiscoveredMutations() {
        return this.discoveredMutations;
    }

    public Set<ResourceLocation> getResearchedMutations() {
        return this.researchedMutations;
    }

    @Override
    public boolean isDiscovered(Species species) {
        return this.discoveredSpecies.contains(SpeciesRegistration.getResourceLocation(species));
    }

    @Override
    public boolean isDiscovered(Mutation mutation) {
        return this.discoveredMutations.contains(MutationRegistration.getResourceLocation(mutation));
    }

    @Override
    public boolean isResearched(Mutation mutation) {
        return this.researchedMutations.contains(MutationRegistration.getResourceLocation(mutation));
    }

    public void discoverIndividual(ItemStack stack) {
        if (stack.m_204117_(ItemTagGenerator.BEE)) {
            this.discover(GeneticHelper.getSpecies(stack, true));
            if (stack.m_41784_().m_128471_("analyzed")) {
                this.discover(GeneticHelper.getSpecies(stack, false));
            }
        }
    }

    @Override
    public void discover(Species species) {
        if (!this.isDiscovered(species)) {
            ResourceLocation loc = SpeciesRegistration.getResourceLocation(species);
            this.discoveredSpecies.add(loc);
            this.m_77762_();
        }
    }

    @Override
    public void discover(Mutation mutation) {
        if (!this.isDiscovered(mutation)) {
            ResourceLocation loc = MutationRegistration.getResourceLocation(mutation);
            this.discoveredMutations.add(loc);
            this.m_77762_();
            this.sendUpdateToPlayer(TrackerUpdateClientbound.UpdateType.MUTATION, loc);
        }
    }

    @Override
    public void research(Mutation mutation) {
        if (!this.isResearched(mutation)) {
            ResourceLocation loc = MutationRegistration.getResourceLocation(mutation);
            this.researchedMutations.add(loc);
            this.m_77762_();
            this.sendUpdateToPlayer(TrackerUpdateClientbound.UpdateType.RESEARCH, loc);
        }
    }

    public void clearSpecies() {
        this.discoveredSpecies.clear();
        this.m_77762_();
        this.syncToPlayer();
    }

    public void clearMutations() {
        this.discoveredMutations.clear();
        this.m_77762_();
        this.syncToPlayer();
    }

    public void clearResearch() {
        this.researchedMutations.clear();
        this.m_77762_();
        this.syncToPlayer();
    }

    public void syncToPlayer() {
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.getUUID())), (Object)new TrackerSyncClientbound(this));
    }

    public void sendUpdateToPlayer(TrackerUpdateClientbound.UpdateType type, ResourceLocation loc) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.getUUID())), (Object)new TrackerUpdateClientbound(type, loc));
        }
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        pCompoundTag.m_128362_(UUID_KEY, this.playerId);
        BreedingTracker.writeListToNBT(pCompoundTag, this.discoveredSpecies, SPECIES_KEY);
        BreedingTracker.writeListToNBT(pCompoundTag, this.discoveredMutations, MUTATIONS_KEY);
        BreedingTracker.writeListToNBT(pCompoundTag, this.researchedMutations, RESEARCH_KEY);
        return pCompoundTag;
    }

    public static BreedingTracker load(CompoundTag tag) {
        if (!tag.m_128441_(UUID_KEY)) {
            throw new NullPointerException("tried to load breeding tracker with no uuid!");
        }
        BreedingTracker tracker = new BreedingTracker(tag.m_128342_(UUID_KEY));
        BreedingTracker.readListFromNBT(tag, str -> tracker.discoveredSpecies.add(ResourceLocation.m_135820_((String)str)), SPECIES_KEY);
        BreedingTracker.readListFromNBT(tag, str -> tracker.discoveredMutations.add(ResourceLocation.m_135820_((String)str)), MUTATIONS_KEY);
        BreedingTracker.readListFromNBT(tag, str -> tracker.researchedMutations.add(ResourceLocation.m_135820_((String)str)), RESEARCH_KEY);
        return tracker;
    }

    private static void writeListToNBT(CompoundTag tag, Iterable<ResourceLocation> values, String key) {
        ListTag listTag = new ListTag();
        for (ResourceLocation value : values) {
            listTag.add((Object)StringTag.m_129297_((String)value.toString()));
        }
        tag.m_128365_(key, (Tag)listTag);
    }

    private static void readListFromNBT(CompoundTag tag, Consumer<String> consumer, String key) {
        if (tag.m_128441_(key)) {
            ListTag listTag = tag.m_128437_(key, 8);
            for (Tag stringTag : listTag) {
                consumer.accept(stringTag.m_7916_());
            }
        }
    }

    public static BreedingTracker getTracker(Player player) {
        return BreedingTracker.getTracker(player.m_20148_());
    }

    public static BreedingTracker getTracker(UUID uuid) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return CLIENT_INSTANCE;
        }
        DimensionDataStorage storage = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
        return (BreedingTracker)storage.m_164861_(BreedingTracker::load, () -> new BreedingTracker(uuid), "complicated_bees." + uuid.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateFromPacket(TrackerUpdateClientbound packet) {
        switch (packet.type()) {
            case SPECIES: {
                BreedingTracker.CLIENT_INSTANCE.discoveredSpecies.add(packet.loc());
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new DiscoverToast(SpeciesRegistration.getFromResourceLocation(packet.loc())));
                break;
            }
            case MUTATION: {
                BreedingTracker.CLIENT_INSTANCE.discoveredMutations.add(packet.loc());
                break;
            }
            case RESEARCH: {
                BreedingTracker.CLIENT_INSTANCE.researchedMutations.add(packet.loc());
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ResearchToast(MutationRegistration.getFromResourceLocation(packet.loc())));
            }
        }
    }

    static {
        UUID_KEY = "uuid";
        SPECIES_KEY = "species";
        MUTATIONS_KEY = "mutations";
        RESEARCH_KEY = "researched";
    }
}

