/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.bees.BeeLogic;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.BaseBeeHousing;
import com.accbdd.complicated_bees.item.BeeItem;
import com.accbdd.complicated_bees.item.DroneItem;
import com.accbdd.complicated_bees.item.FrameItem;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import java.util.Stack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ApiaryBlockEntity
extends BaseBeeHousing {
    BeeLogic beeLogic;
    private final Stack<ItemStack> outputBuffer = new Stack();
    private final ItemStackHandler beeItems = this.createBeeHandler();
    private final ItemStackHandler outputItems = this.createOutputHandler();
    private final ItemStackHandler frameItems = this.createFrameHandler();
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.beeItems, this.outputItems, this.frameItems}));
    private final LazyOptional<IItemHandlerModifiable> beeItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.beeItems){

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    });
    private final LazyOptional<IItemHandlerModifiable> outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    });
    private final LazyOptional<IItemHandlerModifiable> frameItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.frameItems){

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof FrameItem;
        }
    });

    public ApiaryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.APIARY_ENTITY.get(), pPos, pBlockState);
        this.beeLogic = new BeeLogic(this.m_58904_(), this.m_58899_(), this);
    }

    @Override
    public ItemStackHandler getBeeItems() {
        return this.beeItems;
    }

    @Override
    public ItemStackHandler getOutputItems() {
        return this.outputItems;
    }

    @Override
    public ItemStackHandler getFrameItems() {
        return this.frameItems;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getBeeItemHandler() {
        return this.beeItemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getOutputItemHandler() {
        return this.outputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getFrameItemHandler() {
        return this.frameItemHandler;
    }

    @Override
    public Stack<ItemStack> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public BeeLogic getLogic() {
        return this.beeLogic;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.beeLogic.setLevel(this.m_58904_());
    }

    private ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                ApiaryBlockEntity.this.m_6596_();
            }
        };
    }

    private ItemStackHandler createFrameHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                ApiaryBlockEntity.this.m_6596_();
                ApiaryBlockEntity.this.getLogic().clearConditionCache();
            }
        };
    }

    private ItemStackHandler createBeeHandler() {
        return new ItemStackHandler(2){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                boolean itemValid = this.isItemValid(slot, stack);
                return itemValid ? super.insertItem(slot, stack, simulate) : stack;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.m_41720_() instanceof BeeItem) {
                    switch (slot) {
                        case 0: {
                            return stack.m_41720_() instanceof QueenItem || stack.m_41720_() instanceof PrincessItem;
                        }
                        case 1: {
                            return stack.m_41720_() instanceof DroneItem;
                        }
                    }
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 0) {
                    ApiaryBlockEntity.this.getLogic().setQueen(this.getStackInSlot(0));
                    ApiaryBlockEntity.this.getLogic().clearFlowerCache();
                    ApiaryBlockEntity.this.getLogic().checkConditions();
                }
                ApiaryBlockEntity.this.m_6596_();
            }
        };
    }
}

