/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.bees.BeeLogic;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.IBeeHousing;
import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.effect.IBeeEffect;
import com.accbdd.complicated_bees.bees.gene.GeneEffect;
import com.accbdd.complicated_bees.bees.gene.GeneFertility;
import com.accbdd.complicated_bees.bees.gene.GeneLifespan;
import com.accbdd.complicated_bees.bees.gene.GeneProductivity;
import com.accbdd.complicated_bees.bees.gene.GeneSpecies;
import com.accbdd.complicated_bees.bees.gene.enums.EnumLifespan;
import com.accbdd.complicated_bees.bees.gene.enums.EnumProductivity;
import com.accbdd.complicated_bees.config.Config;
import com.accbdd.complicated_bees.item.BeeItem;
import com.accbdd.complicated_bees.item.DroneItem;
import com.accbdd.complicated_bees.item.FrameItem;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.util.enums.EnumErrorCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBeeHousing
extends BlockEntity
implements IBeeHousing {
    public static final int BEE_SLOT = 0;
    public static final int BEE_SLOT_COUNT = 2;
    public static final String ITEMS_BEES_TAG = "bee_items";
    public static final int OUTPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_COUNT = 7;
    public static final String ITEMS_OUTPUT_TAG = "output_items";
    public static final int FRAME_SLOT = 0;
    public static final int FRAME_SLOT_COUNT = 3;
    public static final String FRAME_SLOT_TAG = "frame_slots";
    public static final int SLOT_COUNT = 12;
    public static final String OUTPUT_BUFFER_TAG = "output_buffer";
    public static final int CYCLE_LENGTH = (Integer)Config.CONFIG.productionCycleLength.get();
    public static final String CYCLE_TAG = "cycle";
    public static final int SATISFY_CYCLE_LENGTH = (Integer)Config.CONFIG.enviroCycleLength.get();
    public static final String OWNER_TAG = "owner";
    private UUID owner = null;
    private final ContainerData data;
    private int cycleProgress = 0;
    private int satisfyCycleProgress = 0;
    private int matingProgress = 0;
    private int maxMatingProgress = 20;
    private int errorState = 0;
    private final BeeLogic beeLogic = new BeeLogic(this.m_58904_(), this.m_58899_(), this);

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getItemHandler().invalidate();
        this.getBeeItemHandler().invalidate();
        this.getOutputItemHandler().invalidate();
        this.getFrameItemHandler().invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.getItemHandler().cast();
            }
            if (side == Direction.DOWN) {
                return this.getOutputItemHandler().cast();
            }
            return this.getBeeItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public BaseBeeHousing(BlockEntityType<?> type, BlockPos pPos, BlockState pBlockState) {
        super(type, pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> BaseBeeHousing.this.matingProgress;
                    case 1 -> BaseBeeHousing.this.maxMatingProgress;
                    case 2 -> BaseBeeHousing.this.errorState;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        BaseBeeHousing.this.matingProgress = value;
                        break;
                    }
                    case 1: {
                        BaseBeeHousing.this.maxMatingProgress = value;
                        break;
                    }
                    case 2: {
                        BaseBeeHousing.this.errorState = value;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public abstract ItemStackHandler getBeeItems();

    public abstract ItemStackHandler getOutputItems();

    public abstract ItemStackHandler getFrameItems();

    @Override
    public abstract LazyOptional<IItemHandlerModifiable> getItemHandler();

    @Override
    public abstract LazyOptional<IItemHandlerModifiable> getBeeItemHandler();

    @Override
    public abstract LazyOptional<IItemHandlerModifiable> getOutputItemHandler();

    @Override
    public abstract LazyOptional<IItemHandlerModifiable> getFrameItemHandler();

    public abstract Stack<ItemStack> getOutputBuffer();

    @Override
    public abstract BeeLogic getLogic();

    public ContainerData getData() {
        return this.data;
    }

    public int getCycleProgress() {
        return CYCLE_LENGTH - this.cycleProgress;
    }

    @Override
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(CYCLE_TAG, (Tag)IntTag.m_128679_((int)this.cycleProgress));
        tag.m_128365_(ITEMS_BEES_TAG, (Tag)this.getBeeItems().serializeNBT());
        tag.m_128365_(ITEMS_OUTPUT_TAG, (Tag)this.getOutputItems().serializeNBT());
        tag.m_128365_(FRAME_SLOT_TAG, (Tag)this.getFrameItems().serializeNBT());
        if (this.getOwner() != null) {
            tag.m_128362_(OWNER_TAG, this.getOwner());
        }
        ListTag bufferTag = new ListTag();
        for (ItemStack stack : this.getOutputBuffer()) {
            bufferTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(OUTPUT_BUFFER_TAG, (Tag)bufferTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cycleProgress = tag.m_128451_(CYCLE_TAG);
        if (tag.m_128441_(ITEMS_BEES_TAG)) {
            this.getBeeItems().deserializeNBT(tag.m_128469_(ITEMS_BEES_TAG));
        }
        if (tag.m_128441_(ITEMS_OUTPUT_TAG)) {
            this.getOutputItems().deserializeNBT(tag.m_128469_(ITEMS_OUTPUT_TAG));
        }
        if (tag.m_128441_(FRAME_SLOT_TAG)) {
            this.getFrameItems().deserializeNBT(tag.m_128469_(FRAME_SLOT_TAG));
        }
        if (tag.m_128441_(OUTPUT_BUFFER_TAG)) {
            for (Tag itemCompound : tag.m_128437_(OUTPUT_BUFFER_TAG, 10)) {
                this.getOutputBuffer().add(ItemStack.m_41712_((CompoundTag)((CompoundTag)itemCompound)));
            }
        }
        if (tag.m_128441_(OWNER_TAG)) {
            this.setOwner(tag.m_128342_(OWNER_TAG));
        }
        this.satisfyCycleProgress = new Random().nextInt(0, SATISFY_CYCLE_LENGTH);
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLogic() != null) {
            this.getLogic().setLevel(this.m_58904_());
        }
    }

    public void tickServer() {
        ItemStack top_stack = this.getBeeItems().getStackInSlot(0);
        ItemStack bottom_stack = this.getBeeItems().getStackInSlot(1);
        if (!this.getOutputBuffer().empty()) {
            this.tryEmptyBuffer();
        }
        if (top_stack.m_41720_() instanceof PrincessItem && bottom_stack.m_41720_() instanceof DroneItem) {
            this.increaseMatingProgress();
            if (this.hasFinished()) {
                this.resetMatingProgress();
                this.getBeeItems().extractItem(1, 1, false);
                this.getBeeItems().setStackInSlot(0, GeneticHelper.createQueenFromPrincessAndDrone(top_stack, bottom_stack));
                this.getLogic().setLevel(this.m_58904_());
                this.getLogic().rebuildFlowerCache();
                this.getLogic().checkConditions();
            }
        } else {
            this.resetMatingProgress();
        }
        if (this.satisfyCycleProgress >= SATISFY_CYCLE_LENGTH) {
            if (top_stack.m_41720_() instanceof QueenItem) {
                this.getLogic().setQueen(top_stack);
                this.getLogic().checkConditions();
                this.satisfyCycleProgress = 0;
            }
        } else {
            ++this.satisfyCycleProgress;
        }
        if (top_stack.m_41720_() instanceof QueenItem) {
            if (this.getLogic().isQueenSatisfied()) {
                this.doBeeEffect();
                if (this.cycleProgress < CYCLE_LENGTH) {
                    ++this.cycleProgress;
                } else {
                    this.cycleProgress = 0;
                    this.beeTick();
                }
            }
        } else {
            this.cycleProgress = 0;
        }
    }

    @Override
    public void doBeeEffect() {
        IBeeEffect effect;
        if (this.getBeeItems().getStackInSlot(0).m_41720_() instanceof QueenItem && (effect = (IBeeEffect)GeneticHelper.getGeneValue(this.getBeeItems().getStackInSlot(0), GeneEffect.ID, true)) != null) {
            effect.runEffect(this, this.getBeeItems().getStackInSlot(0), this.cycleProgress);
        }
    }

    private void tryEmptyBuffer() {
        while (!this.getOutputBuffer().empty()) {
            ItemStack next = this.getOutputBuffer().pop();
            next = ItemHandlerHelper.insertItem((IItemHandler)this.getOutputItems(), (ItemStack)next, (boolean)false);
            if (next == ItemStack.f_41583_) {
                this.m_6596_();
                this.removeError(EnumErrorCodes.OUTPUT_FULL);
                continue;
            }
            this.getOutputBuffer().push(next);
            this.addError(EnumErrorCodes.OUTPUT_FULL);
            break;
        }
    }

    @Override
    public void addToOutput(ItemStack stack) {
        this.getOutputBuffer().add(stack);
    }

    @Override
    public boolean isQueenSatisfied() {
        return this.getLogic().isQueenSatisfied();
    }

    @Override
    public boolean isQueenEcstatic() {
        return this.getLogic().isQueenEcstatic();
    }

    @Override
    public void beeTick() {
        ItemStack top_stack = this.getBeeItems().getStackInSlot(0);
        this.ageQueen(top_stack);
        this.generateProduce(top_stack);
        this.damageFrames();
    }

    public void generateProduce(ItemStack bee) {
        Species species = (Species)GeneticHelper.getGeneValue(bee, GeneSpecies.ID, true);
        float housingModifiers = this.getHousingModifiers().stream().map(BeeHousingModifier::getProductivityMod).reduce(Float.valueOf(1.0f), (cur, next) -> Float.valueOf(cur.floatValue() * next.floatValue())).floatValue();
        for (Product product : species.getProducts()) {
            this.getOutputBuffer().add(product.getStackResult(((EnumProductivity)((Object)GeneticHelper.getGeneValue((ItemStack)bee, (ResourceLocation)GeneProductivity.ID, (boolean)true))).value, housingModifiers));
        }
        if (this.getErrors() == EnumErrorCodes.ECSTATIC.value) {
            for (Product special : species.getSpecialtyProducts()) {
                this.getOutputBuffer().add(special.getStackResult(((EnumProductivity)((Object)GeneticHelper.getGeneValue((ItemStack)bee, (ResourceLocation)GeneProductivity.ID, (boolean)true))).value, housingModifiers));
            }
        }
        this.m_6596_();
    }

    public void ageQueen(ItemStack queen) {
        float ageFactor = 1.0f;
        for (BeeHousingModifier mod : this.getHousingModifiers()) {
            ageFactor /= mod.getLifespanMod();
        }
        BeeItem.setAge(queen, BeeItem.getAge(queen) + ageFactor);
        if (BeeItem.getAge(queen) >= (float)((EnumLifespan)((Object)GeneticHelper.getGeneValue((ItemStack)queen, (ResourceLocation)GeneLifespan.ID, (boolean)true))).value) {
            this.produceOffspring(queen);
        }
    }

    public void produceOffspring(ItemStack queen) {
        this.errorState = 0;
        float mutationMod = this.getHousingModifiers().stream().map(BeeHousingModifier::getMutationMod).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
        this.getOutputBuffer().add(GeneticHelper.getOffspring(queen, (Item)ItemsRegistration.PRINCESS.get(), this.m_58904_(), this.m_58899_(), mutationMod));
        for (int i = 0; i < (Integer)GeneticHelper.getGeneValue(queen, GeneFertility.ID, true); ++i) {
            this.getOutputBuffer().add(GeneticHelper.getOffspring(queen, (Item)ItemsRegistration.DRONE.get(), this.m_58904_(), this.m_58899_(), mutationMod));
        }
        this.getBeeItems().extractItem(0, 1, false);
        this.m_6596_();
    }

    @Override
    public List<BeeHousingModifier> getHousingModifiers() {
        ArrayList<BeeHousingModifier> modifiers = new ArrayList<BeeHousingModifier>();
        for (int i = 0; i < this.getFrameItems().getSlots(); ++i) {
            ItemStack item = this.getFrameItems().getStackInSlot(i);
            Item item2 = item.m_41720_();
            if (!(item2 instanceof FrameItem)) continue;
            FrameItem frame = (FrameItem)item2;
            modifiers.add(frame.getModifier());
        }
        return modifiers;
    }

    public void damageFrames() {
        for (int i = 0; i < this.getFrameItems().getSlots(); ++i) {
            if (!this.getFrameItems().getStackInSlot(i).m_220157_(1, this.m_58904_().f_46441_, null)) continue;
            this.getFrameItems().setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    private void increaseMatingProgress() {
        ++this.matingProgress;
        this.m_6596_();
    }

    private boolean hasFinished() {
        return this.matingProgress >= this.maxMatingProgress;
    }

    private void resetMatingProgress() {
        this.matingProgress = 0;
    }

    @Override
    public void addError(EnumErrorCodes ... error) {
        for (EnumErrorCodes err : error) {
            this.errorState |= err.value;
        }
    }

    @Override
    public void removeError(EnumErrorCodes ... error) {
        for (EnumErrorCodes err : error) {
            this.errorState &= err.value ^ Integer.MAX_VALUE;
        }
    }

    @Override
    public int getErrors() {
        return this.data.m_6413_(2);
    }
}

