/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.block.entity.AdaptedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.config.Config;
import com.accbdd.complicated_bees.recipe.CentrifugeRecipe;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CentrifugeBlockEntity
extends BlockEntity {
    public static final int INPUT_SLOT = 0;
    public static final int INPUT_SLOT_COUNT = 1;
    public static final String ITEMS_INPUT_TAG = "input_items";
    public static final int OUTPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_COUNT = 9;
    public static final String ITEMS_OUTPUT_TAG = "output_items";
    public static final int SLOT_COUNT = 10;
    public final Stack<ItemStack> outputBuffer = new Stack();
    public static final String OUTPUT_BUFFER_TAG = "output_buffer";
    public static final String ENERGY_TAG = "energy";
    public static final int CAPACITY = 100000;
    public static final int MAXTRANSFER = 5000;
    public static final int USAGE = (Integer)Config.CONFIG.centrifugeEnergy.get();
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 20;
    private final RecipeManager.CachedCheck<Container, CentrifugeRecipe> quickCheck;
    private final ItemStackHandler inputItems = this.createItemHandler(1);
    private final ItemStackHandler outputItems = this.createItemHandler(9);
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputItems, this.outputItems}));
    private final LazyOptional<IItemHandler> inputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.inputItems){

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    });
    private final LazyOptional<IItemHandler> outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

        @Override
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    });
    private final EnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage((IEnergyStorage)this.energy){

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            CentrifugeBlockEntity.this.m_6596_();
            return super.receiveEnergy(maxReceive, simulate);
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return true;
        }
    });

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.inputItemHandler.invalidate();
        this.outputItemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.getItemHandler().cast();
            }
            if (side == Direction.DOWN) {
                return this.getOutputItemHandler().cast();
            }
            return this.getInputItemHandler().cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public CentrifugeBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntitiesRegistration.CENTRIFUGE_ENTITY.get(), pos, blockState);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)EsotericRegistration.CENTRIFUGE_RECIPE.get()));
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> CentrifugeBlockEntity.this.progress;
                    case 1 -> CentrifugeBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        CentrifugeBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        CentrifugeBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public ItemStackHandler getInputItems() {
        return this.inputItems;
    }

    public ItemStackHandler getOutputItems() {
        return this.outputItems;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getInputItemHandler() {
        return this.inputItemHandler;
    }

    public LazyOptional<IItemHandler> getOutputItemHandler() {
        return this.outputItemHandler;
    }

    private ItemStackHandler createItemHandler(int slots) {
        return new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                CentrifugeBlockEntity.this.m_6596_();
            }
        };
    }

    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(100000, 5000, 5000);
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public int getStoredPower() {
        return this.energy.getEnergyStored();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_INPUT_TAG, (Tag)this.inputItems.serializeNBT());
        tag.m_128365_(ITEMS_OUTPUT_TAG, (Tag)this.outputItems.serializeNBT());
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
        ListTag bufferTag = new ListTag();
        for (ItemStack stack : this.outputBuffer) {
            bufferTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(OUTPUT_BUFFER_TAG, (Tag)bufferTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_INPUT_TAG)) {
            this.inputItems.deserializeNBT(tag.m_128469_(ITEMS_INPUT_TAG));
        }
        if (tag.m_128441_(ITEMS_OUTPUT_TAG)) {
            this.outputItems.deserializeNBT(tag.m_128469_(ITEMS_OUTPUT_TAG));
        }
        if (tag.m_128441_(OUTPUT_BUFFER_TAG)) {
            for (Tag itemCompound : tag.m_128437_(OUTPUT_BUFFER_TAG, 10)) {
                this.outputBuffer.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)itemCompound)));
            }
        }
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
    }

    public void tickServer() {
        ItemStack stack = this.inputItems.getStackInSlot(0);
        if (!this.outputBuffer.empty()) {
            this.tryEmptyBuffer();
        }
        if (this.hasRecipe(stack) && this.energy.getEnergyStored() > 0 && this.outputBuffer.empty()) {
            if (!((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            }
            this.increaseCraftingProgress();
            this.m_6596_();
            if (this.hasFinished()) {
                this.craftItem(stack);
                this.resetProgress();
            }
        } else {
            if (((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
            }
            this.lowerProgress();
        }
    }

    private void lowerProgress() {
        if (this.progress > 0) {
            --this.progress;
        }
    }

    private void tryEmptyBuffer() {
        while (!this.outputBuffer.empty()) {
            ItemStack next = this.outputBuffer.pop();
            if ((next = ItemHandlerHelper.insertItem((IItemHandler)this.outputItems, (ItemStack)next, (boolean)false)) == ItemStack.f_41583_) {
                this.m_6596_();
                continue;
            }
            this.outputBuffer.push(next);
            break;
        }
    }

    private void increaseCraftingProgress() {
        this.energy.extractEnergy(USAGE, false);
        ++this.progress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasRecipe(ItemStack stack) {
        Optional recipeCheck = this.quickCheck.m_213657_((Container)this.getWrapper(), this.m_58904_());
        if (recipeCheck.isPresent()) {
            ItemStack primary = ItemStack.f_41583_;
            CentrifugeRecipe recipe = (CentrifugeRecipe)recipeCheck.get();
            if (!recipe.getOutputs().isEmpty()) {
                primary = recipe.getOutputs().get(0).getStack();
            }
            return this.canInsertIntoOutput(primary);
        }
        return false;
    }

    private boolean hasFinished() {
        return this.progress >= this.maxProgress;
    }

    private void craftItem(ItemStack stack) {
        List<Product> products = ((CentrifugeRecipe)this.quickCheck.m_213657_((Container)this.getWrapper(), this.m_58904_()).get()).getOutputs();
        this.inputItems.extractItem(0, 1, false);
        for (Product product : products) {
            this.outputBuffer.push(product.getStackResult(new float[0]));
        }
    }

    private boolean canInsertIntoOutput(ItemStack stack) {
        boolean canInsert = false;
        int stackCount = stack.m_41613_();
        for (int i = 0; i < 9; ++i) {
            stack = this.outputItems.insertItem(i, stack, true);
            canInsert = canInsert || stack.m_41613_() < stackCount;
        }
        return canInsert;
    }

    public ContainerData getData() {
        return this.data;
    }

    public RecipeWrapper getWrapper() {
        return new RecipeWrapper((IItemHandlerModifiable)this.inputItems);
    }
}

