/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.block.entity.AdaptedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.config.Config;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GeneratorBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    public static final String ENERGY_TAG = "energy";
    public static final String BURN_TIME_TAG = "burn_time";
    public static final int GENERATE = (Integer)Config.CONFIG.generatorEnergy.get();
    public static final int MAXTRANSFER = 1000;
    public static final int CAPACITY = 100000;
    public static final int SLOT_COUNT = 1;
    public static final int SLOT = 0;
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items){

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    });
    private final EnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage((IEnergyStorage)this.energy){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    });
    private int burnTime;
    private int maxBurnTime;

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public GeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesRegistration.GENERATOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void tickServer() {
        this.generateEnergy();
        this.distributeEnergy();
    }

    private void generateEnergy() {
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
            if (this.burnTime <= 0) {
                int burnTime;
                ItemStack fuel = this.items.getStackInSlot(0);
                if (fuel.m_41619_()) {
                    return;
                }
                this.maxBurnTime = burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
                this.setBurnTime(burnTime);
                if (burnTime <= 0) {
                    return;
                }
                this.items.extractItem(0, 1, false);
            } else {
                this.setBurnTime(this.burnTime - 1);
                this.energy.receiveEnergy(GENERATE, false);
            }
            this.m_6596_();
        }
    }

    private void setBurnTime(int bt) {
        if (bt == this.burnTime) {
            return;
        }
        this.burnTime = bt;
        if ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) != this.burnTime > 0) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.burnTime > 0)));
        }
        this.m_6596_();
    }

    private void distributeEnergy() {
        for (Direction direction : Direction.values()) {
            IEnergyStorage energy;
            if (this.energy.getEnergyStored() <= 0) {
                return;
            }
            BlockEntity be = this.m_58904_().m_7702_(this.m_58899_().m_121945_(direction));
            if (be == null || (energy = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY).orElse(null)) == null || !energy.canReceive()) continue;
            int received = energy.receiveEnergy(Math.min(this.energy.getEnergyStored(), 1000), false);
            this.energy.extractEnergy(received, false);
            this.m_6596_();
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public int getStoredPower() {
        return this.energy.getEnergyStored();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
        tag.m_128365_(BURN_TIME_TAG, (Tag)IntTag.m_128679_((int)this.burnTime));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
        if (tag.m_128441_(BURN_TIME_TAG)) {
            this.maxBurnTime = this.burnTime = tag.m_128451_(BURN_TIME_TAG);
        }
    }

    @Nonnull
    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                GeneratorBlockEntity.this.m_6596_();
            }
        };
    }

    @Nonnull
    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(100000, 1000, 1000);
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }
}

