/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.mellarium;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumModifier;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumTickable;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumAbstractBlockEntity;
import com.accbdd.complicated_bees.item.FrameItem;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MellariumFrameHousingBlockEntity
extends MellariumAbstractBlockEntity
implements IMellariumModifier,
IMellariumTickable {
    private final ItemStackHandler frameItems;
    private final LazyOptional<IItemHandler> frameItemHandler;

    public MellariumFrameHousingBlockEntity(BlockPos pPos, BlockState pBlockState, int frameSlots) {
        super(BlockEntitiesRegistration.MELLARIUM_FRAME_HOUSING_ENTITIES.get(frameSlots - 1).get(), pPos, pBlockState);
        this.frameItems = new ItemStackHandler(frameSlots){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof FrameItem;
            }
        };
        this.frameItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.frameItems));
    }

    public LazyOptional<IItemHandler> getFrameItemHandler() {
        return this.frameItemHandler;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.getLogic() == null || this.getLogic().getController() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getFrameItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getFrameItemHandler().invalidate();
    }

    @Override
    public BeeHousingModifier getModifier() {
        ArrayList<BeeHousingModifier> modifiers = new ArrayList<BeeHousingModifier>();
        for (int i = 0; i < this.frameItems.getSlots(); ++i) {
            ItemStack stack = this.frameItems.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof FrameItem)) continue;
            FrameItem frame = (FrameItem)item;
            modifiers.add(frame.getModifier());
        }
        return BeeHousingModifier.of(modifiers.toArray(new BeeHousingModifier[0]));
    }

    @Override
    public void onBeeTick() {
        this.damageFrames();
    }

    public void damageFrames() {
        for (int i = 0; i < this.frameItems.getSlots(); ++i) {
            if (!this.frameItems.getStackInSlot(i).m_220157_(1, this.m_58904_().f_46441_, null)) continue;
            this.frameItems.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("frame_items", (Tag)this.frameItems.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("frame_items")) {
            this.frameItems.deserializeNBT(pTag.m_128469_("frame_items"));
        }
    }
}

