/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.mellarium;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumModifier;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumTickable;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumAbstractBlockEntity;
import com.accbdd.complicated_bees.recipe.TempUnitRecipe;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MellariumTempUnitBlockEntity
extends MellariumAbstractBlockEntity
implements IMellariumModifier,
IMellariumTickable {
    private static final String ITEMS_TAG = "Items";
    private final ItemStackHandler items = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return MellariumTempUnitBlockEntity.this.hasRecipe(stack);
        }
    };
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items));
    private final RecipeManager.CachedCheck<Container, TempUnitRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)EsotericRegistration.TEMP_UNIT_RECIPE.get()));

    public MellariumTempUnitBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.MELLARIUM_TEMP_UNIT_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    private boolean hasRecipe(ItemStack stack) {
        Optional recipeCheck = this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.m_58904_());
        return recipeCheck.isPresent();
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(pTag.m_128469_(ITEMS_TAG));
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.getLogic() == null || this.getLogic().getController() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getItemHandler().invalidate();
    }

    @Override
    public BeeHousingModifier getModifier() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (this.hasRecipe(stack)) {
            return new BeeHousingModifier.Builder().temperature(((TempUnitRecipe)this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.m_58904_()).get()).getTempChange()).build();
        }
        return new BeeHousingModifier();
    }

    @Override
    public void onBeeTick() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (this.hasRecipe(stack)) {
            SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{stack});
            if (this.f_58857_.m_213780_().m_188501_() < ((TempUnitRecipe)this.quickCheck.m_213657_((Container)simpleContainer, this.m_58904_()).get()).getUseChance()) {
                if (stack.hasCraftingRemainingItem()) {
                    this.items.setStackInSlot(0, stack.getCraftingRemainingItem());
                    this.getLogic().getController().getLogic().clearConditionCache();
                    this.getLogic().getController().getLogic().checkConditions();
                } else {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        this.getLogic().getController().getLogic().clearConditionCache();
                        this.getLogic().getController().getLogic().checkConditions();
                    }
                }
            }
        }
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }
}

