/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.client;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DiscoverToast
implements Toast {
    private static final ResourceLocation TEXTURE = new ResourceLocation("complicated_bees", "textures/gui/toasts.png");
    private static final long DISPLAY_TIME = 5000L;
    private static final Component TITLE_TEXT = Component.m_237113_((String)"New Species Discovered!");
    private final Component descriptionText;
    private final Species species;
    private long lastChanged;
    private boolean changed;

    public DiscoverToast(Species species) {
        this.species = species;
        this.descriptionText = GeneticHelper.getTranslationKey(species).m_130946_(" - ").m_7220_((Component)GeneticHelper.getSpeciesTaxonomyKey(species).m_130940_(ChatFormatting.ITALIC));
    }

    public Toast.Visibility m_7172_(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        if (this.changed) {
            this.lastChanged = pTimeSinceLastVisible;
            this.changed = false;
        }
        pGuiGraphics.m_280218_(TEXTURE, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        pGuiGraphics.m_280614_(pToastComponent.m_94929_().f_91062_, TITLE_TEXT, 30, 7, -11534256, false);
        pGuiGraphics.m_280614_(pToastComponent.m_94929_().f_91062_, this.descriptionText, 30, 18, -16777216, false);
        ItemStack drone = this.species.toStack((Item)ItemsRegistration.DRONE.get());
        pGuiGraphics.m_280203_(drone, 8, 8);
        return (double)(pTimeSinceLastVisible - this.lastChanged) >= 5000.0 * pToastComponent.m_264542_() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

