/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.client;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class OptimizedBeeModelLoader
implements IGeometryLoader<BeeGeometry> {
    public static final ResourceLocation ID = new ResourceLocation("complicated_bees", "optimized_bee_model");

    public BeeGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        return new BeeGeometry((UnbakedModel)deserializationContext.deserialize(jsonObject.get("base_model"), BlockModel.class));
    }

    static class BeeGeometry
    implements IUnbakedGeometry<BeeGeometry> {
        private final UnbakedModel model;

        BeeGeometry(UnbakedModel model) {
            this.model = model;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedModel = this.model.m_7611_(baker, spriteGetter, modelState, modelLocation);
            return new BeeOverrideModel(bakedModel, baker, modelState, spriteGetter);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.model.m_5500_(modelGetter);
        }
    }

    private static class BeeOverrideList
    extends ItemOverrides {
        public final HashMap<Species, Variant> cacheMap = new HashMap();
        private final ModelBaker baker;
        private final ModelState state;
        private final Function<Material, TextureAtlasSprite> sprites;

        public BeeOverrideList(ModelBaker baker, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            this.baker = baker;
            this.state = state;
            this.sprites = sprites;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel bakedModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            Species species = GeneticHelper.getSpecies(stack, true);
            this.cacheMap.computeIfAbsent(species, spec -> {
                BeeModel[] beeModels = new BeeModel[3];
                for (int i = 0; i < 3; ++i) {
                    if (spec == null) {
                        beeModels[i] = new BeeModel(bakedModel, List.of());
                        continue;
                    }
                    ResourceLocation modelLoc = spec.getModels().get(i);
                    BakedModel bakedModelOverride = this.baker.bake(modelLoc, this.state, this.sprites);
                    ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(bakedModelOverride.getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, null));
                    beeModels[i] = new BeeModel(bakedModel, quads);
                }
                return new Variant(beeModels[0], beeModels[1], beeModels[2]);
            });
            if (stack.m_150930_((Item)ItemsRegistration.QUEEN.get())) {
                return this.cacheMap.get((Object)species).queen;
            }
            if (stack.m_150930_((Item)ItemsRegistration.PRINCESS.get())) {
                return this.cacheMap.get((Object)species).princess;
            }
            return this.cacheMap.get((Object)species).drone;
        }
    }

    private static class BeeModel
    extends BakedModelWrapper<BakedModel> {
        private final List<BakedQuad> quads;

        BeeModel(BakedModel baked, List<BakedQuad> quads) {
            super(baked);
            this.quads = quads;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (side == null) {
                return this.quads;
            }
            return List.of();
        }

        public BakedModel applyTransform(ItemDisplayContext ctx, PoseStack poseStack, boolean applyLeftHandTransform) {
            this.m_7442_().m_269404_(ctx).m_111763_(applyLeftHandTransform, poseStack);
            return this;
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(this);
        }
    }

    private static class BeeOverrideModel
    extends BakedModelWrapper<BakedModel> {
        private final ItemOverrides overrideList;

        BeeOverrideModel(BakedModel originalModel, ModelBaker baker, ModelState modelState, Function<Material, TextureAtlasSprite> sprites) {
            super(originalModel);
            this.overrideList = new BeeOverrideList(baker, modelState, sprites);
        }

        public ItemOverrides m_7343_() {
            return this.overrideList;
        }
    }

    public record Variant(BeeModel drone, BeeModel princess, BeeModel queen) {
    }
}

