/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.command;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DiscoverCommands
implements Command<CommandSourceStack> {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> root, CommandDispatcher<CommandSourceStack> pDispatcher, CommandBuildContext buildContext) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(Commands.m_82127_((String)"tracking").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"species").then(Commands.m_82127_((String)"clear").executes(context -> DiscoverCommands.clearSpecies((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"species", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)buildContext, SpeciesRegistration.SPECIES_REGISTRY_KEY)).executes(context -> DiscoverCommands.discoverSpecies((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), (Species)ResourceArgument.m_246781_((CommandContext)context, (String)"species", SpeciesRegistration.SPECIES_REGISTRY_KEY).get())))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mutation").then(Commands.m_82127_((String)"clear").executes(context -> DiscoverCommands.clearMutations((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"mutation", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)buildContext, MutationRegistration.MUTATION_REGISTRY_KEY)).executes(context -> DiscoverCommands.discoverMutation((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), (Mutation)ResourceArgument.m_246781_((CommandContext)context, (String)"mutation", MutationRegistration.MUTATION_REGISTRY_KEY).get())))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"research").then(Commands.m_82127_((String)"clear").executes(context -> DiscoverCommands.clearResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))).then(Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"mutation", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)buildContext, MutationRegistration.MUTATION_REGISTRY_KEY)).executes(context -> DiscoverCommands.discoverResearch((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), (Mutation)ResourceArgument.m_246781_((CommandContext)context, (String)"mutation", MutationRegistration.MUTATION_REGISTRY_KEY).get())))))))).then(Commands.m_82127_((String)"setgene").then(Commands.m_82129_((String)"primary", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"gene_name", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"data", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> DiscoverCommands.setGeneData((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"primary"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"gene_name").toString(), CompoundTagArgument.m_87660_((CommandContext)context, (String)"data"))))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int setGeneData(CommandSourceStack source, boolean primary, String geneTag, CompoundTag data) throws CommandSyntaxException {
        if (source.m_230896_() == null) {
            return 0;
        }
        ItemStack held = source.m_230896_().m_21205_();
        if (!held.m_204117_(ItemTagGenerator.BEE)) throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.not_bee")).create();
        if (!held.m_41782_() || !held.m_41783_().m_128441_(primary ? "chromosome_a" : "chromosome_b")) throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.set_gene.corrupt_tag")).create();
        CompoundTag chromosome = held.m_41783_().m_128469_(primary ? "chromosome_a" : "chromosome_b");
        if (!chromosome.m_128441_(geneTag)) throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.set_gene.invalid_gene")).create();
        CompoundTag oldGeneTag = chromosome.m_128469_(geneTag);
        if (!data.m_128431_().equals(oldGeneTag.m_128431_())) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.set_gene.invalid_data")).create();
        }
        chromosome.m_128365_(geneTag, (Tag)data);
        source.m_288197_(() -> Component.m_237115_((String)"command.complicated_bees.set_gene.success"), true);
        return 0;
    }

    private static int clearResearch(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            ++i;
            BreedingTracker.getTracker(player).clearResearch();
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.no_players")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.research.clear", (Object[])new Object[]{finalI}), true);
        return i;
    }

    private static int discoverResearch(CommandSourceStack source, Collection<? extends Entity> targets, Mutation mutation) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            Player player;
            BreedingTracker tracker;
            if (!(entity instanceof Player) || (tracker = BreedingTracker.getTracker(player = (Player)entity)).isResearched(mutation)) continue;
            ++i;
            BreedingTracker.getTracker(player).research(mutation);
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.discover.research.no_change")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.research", (Object[])new Object[]{MutationRegistration.getResourceLocation(mutation), finalI}), true);
        return i;
    }

    private static int clearMutations(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            ++i;
            BreedingTracker.getTracker(player).clearMutations();
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.no_players")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.mutation.clear", (Object[])new Object[]{finalI}), true);
        return i;
    }

    private static int discoverMutation(CommandSourceStack source, Collection<? extends Entity> targets, Mutation mutation) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            Player player;
            BreedingTracker tracker;
            if (!(entity instanceof Player) || (tracker = BreedingTracker.getTracker(player = (Player)entity)).isDiscovered(mutation)) continue;
            ++i;
            BreedingTracker.getTracker(player).discover(mutation);
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.discover.mutation.no_change")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.mutation", (Object[])new Object[]{MutationRegistration.getResourceLocation(mutation), finalI}), true);
        return i;
    }

    private static int clearSpecies(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            ++i;
            BreedingTracker.getTracker(player).clearSpecies();
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.no_players")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.species.clear", (Object[])new Object[]{finalI}), true);
        return i;
    }

    private static int discoverSpecies(CommandSourceStack source, Collection<? extends Entity> targets, Species species) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            Player player;
            BreedingTracker tracker;
            if (!(entity instanceof Player) || (tracker = BreedingTracker.getTracker(player = (Player)entity)).isDiscovered(species)) continue;
            ++i;
            BreedingTracker.getTracker(player).discover(species);
        }
        if (i == 0) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.complicated_bees.discover.species.no_change")).create();
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)"command.complicated_bees.discover.species", (Object[])new Object[]{GeneticHelper.getTranslationKey(species), finalI}), true);
        return i;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return 0;
    }
}

