/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.recipe;

import com.accbdd.complicated_bees.compat.emi.ComplicatedBeesEMI;
import com.accbdd.complicated_bees.recipe.CentrifugeRecipe;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CentrifugeEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final List<EmiStack> outputs;

    public CentrifugeEmiRecipe(CentrifugeRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = recipe.getInput().m_150930_((Item)ItemsRegistration.COMB.get()) ? EmiStack.of((ItemStack)recipe.getInput()).comparison(Comparison.compareNbt()) : EmiStack.of((ItemStack)recipe.getInput());
        this.outputs = recipe.getOutputs().stream().map(p -> EmiStack.of((ItemStack)p.getStack()).setChance(p.getChance())).toList();
    }

    public EmiRecipeCategory getCategory() {
        return ComplicatedBeesEMI.CENTRIFUGE_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 128;
    }

    public int getDisplayHeight() {
        return 64;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(new ResourceLocation("complicated_bees", "textures/gui/jei/centrifuge_products.png"), 0, 0, 128, 64, 0, 0, 128, 64, 128, 64);
        widgets.addSlot(this.input, 14, 23);
        for (int i = 0; i < this.outputs.size(); ++i) {
            widgets.addSlot((EmiIngredient)this.outputs.get(i), 60 + 18 * (i % 3), 5 + 18 * (i / 3)).recipeContext((EmiRecipe)this);
        }
    }
}

