/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.recipe;

import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.compat.emi.ComplicatedBeesEMI;
import com.accbdd.complicated_bees.recipe.HydroRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class HydroEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final EnumTolerance humidityModifier;
    private final float consumeChance;

    public HydroEmiRecipe(HydroRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = EmiIngredient.of((Ingredient)recipe.getInput());
        this.output = EmiStack.of((ItemStack)recipe.getOutput().getStack()).setChance(recipe.getOutput().getChance());
        this.humidityModifier = recipe.getHumidityChange();
        this.consumeChance = recipe.getUseChance();
    }

    public EmiRecipeCategory getCategory() {
        return ComplicatedBeesEMI.HYDROREGULATOR_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 143;
    }

    public int getDisplayHeight() {
        return 40;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(new ResourceLocation("complicated_bees", "textures/gui/jei/two_slot.png"), 0, 0, 143, 40, 0, 0, 143, 40, 143, 40);
        widgets.addSlot(this.input, 3, 11);
        widgets.addSlot((EmiIngredient)this.output, 49, 11).recipeContext((EmiRecipe)this);
        TextWidget widget = widgets.addText((Component)Component.m_237110_((String)"jei.complicated_bees.modifier", (Object[])new Object[]{this.humidityModifier.getTranslationKey()}), 104, 12, 0xFFFFFF, true);
        widget.horizontalAlign(TextWidget.Alignment.CENTER);
        widget.verticalAlign(TextWidget.Alignment.CENTER);
        TextWidget widget2 = widgets.addText((Component)Component.m_237110_((String)"jei.complicated_bees.consumption_chance", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(this.consumeChance * 100.0f))}), 104, 29, 0xFFFFFF, true);
        widget2.horizontalAlign(TextWidget.Alignment.CENTER);
        widget2.verticalAlign(TextWidget.Alignment.CENTER);
    }
}

