/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.jei;

import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.compat.jei.ComplicatedBeesJEI;
import com.accbdd.complicated_bees.config.Config;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MutationRecipeCategory
implements IRecipeCategory<Mutation> {
    public static final ResourceLocation ID = new ResourceLocation("complicated_bees", "jei/mutation");
    public static final RecipeType<Mutation> TYPE = new RecipeType(ID, Mutation.class);
    private static final Component TITLE = Component.m_237115_((String)"gui.complicated_bees.jei.mutations");
    public final IDrawable ICON = ComplicatedBeesJEI.createDrawable(new ResourceLocation("complicated_bees", "textures/item/bee.png"), 0, 0, 16, 16, 16, 16);
    public final IDrawable BACKGROUND = ComplicatedBeesJEI.createDrawable(new ResourceLocation("complicated_bees", "textures/gui/jei/mutations.png"), 0, 0, 143, 40, 143, 40);

    public RecipeType<Mutation> getRecipeType() {
        return TYPE;
    }

    public void draw(Mutation recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        float chance = recipe.getChance() * 100.0f;
        if (BreedingTracker.CLIENT_INSTANCE != null) {
            chance += BreedingTracker.CLIENT_INSTANCE.getResearchedMutations().contains(MutationRegistration.getResourceLocation(recipe)) ? ((Float)Config.CONFIG.researchBonus.get()).floatValue() * 100.0f : 0.0f;
        }
        chance = Math.min(100.0f, chance);
        String chanceString = recipe.getConditions().isEmpty() ? String.format("%.0f%%", Float.valueOf(chance)) : String.format("[%.0f%%]", Float.valueOf(chance));
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, chanceString, 95, 1, 0xFFFFFF);
    }

    public List<Component> getTooltipStrings(Mutation recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tips = new ArrayList<Component>();
        if (mouseX >= 81.0 && mouseX <= 106.0 && mouseY >= 1.0 && mouseY <= 10.0 && !recipe.getConditions().isEmpty()) {
            tips.add((Component)Component.m_237115_((String)"gui.complicated_bees.mutations.has_conditions"));
            for (IMutationCondition condition : recipe.getConditions()) {
                tips.add(condition.getDescription());
            }
        }
        return tips;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Mutation mutation, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 12, 12).setSlotName("first_species").addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, mutation.getFirstSpecies().toMembers());
        builder.addSlot(RecipeIngredientRole.INPUT, 59, 12).setSlotName("second_species").addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, mutation.getSecondSpecies().toMembers());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 12).setSlotName("output_species").addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, mutation.getResultSpecies().toMembers());
    }

    @Nullable
    public ResourceLocation getRegistryName(Mutation recipe) {
        return new ResourceLocation("complicated_bees", Integer.toHexString(recipe.hashCode()));
    }
}

