/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.datagen;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Comb;
import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.datagen.BeeAdvancementGenerator;
import com.accbdd.complicated_bees.datagen.BeeModelGenerator;
import com.accbdd.complicated_bees.datagen.BlockStateGenerator;
import com.accbdd.complicated_bees.datagen.BlockTagGenerator;
import com.accbdd.complicated_bees.datagen.ItemModelGenerator;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.datagen.LootTableGenerator;
import com.accbdd.complicated_bees.datagen.ParticleDescriptionGenerator;
import com.accbdd.complicated_bees.datagen.RecipeGenerator;
import com.accbdd.complicated_bees.datagen.builtin.BuiltIn;
import com.accbdd.complicated_bees.datagen.builtin.BuiltInSpecies;
import com.accbdd.complicated_bees.datagen.builtin.Combs;
import com.accbdd.complicated_bees.datagen.builtin.Flowers;
import com.accbdd.complicated_bees.datagen.builtin.Mutations;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.CombRegistration;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;

public class DataGenerators {
    public static final BlockFamily HONEYED_PLANK_FAMILY = new BlockFamily.Builder((Block)BlocksRegistration.HONEYED_PLANKS.get()).m_175988_((Block)BlocksRegistration.HONEYED_STAIRS.get()).m_175986_((Block)BlocksRegistration.HONEYED_SLAB.get()).m_175982_((Block)BlocksRegistration.HONEYED_FENCE.get()).m_175984_((Block)BlocksRegistration.HONEYED_FENCE_GATE.get()).m_175963_((Block)BlocksRegistration.HONEYED_BUTTON.get()).m_175990_((Block)BlocksRegistration.HONEYED_PRESSURE_PLATE.get()).m_175980_((Block)BlocksRegistration.HONEYED_DOOR.get()).m_175994_((Block)BlocksRegistration.HONEYED_TRAPDOOR.get()).m_175965_((Block)BlocksRegistration.HONEYED_SIGN.get(), (Block)BlocksRegistration.HONEYED_HANGING_SIGN.get()).m_175962_();
    public static final BlockFamily WAX_BLOCK_FAMILY = new BlockFamily.Builder((Block)BlocksRegistration.WAX_BLOCK.get()).m_175988_((Block)BlocksRegistration.WAX_BLOCK_STAIRS.get()).m_175986_((Block)BlocksRegistration.WAX_BLOCK_SLAB.get()).m_175996_((Block)BlocksRegistration.WAX_BLOCK_WALL.get()).m_175962_();
    public static final BlockFamily WAX_BRICK_FAMILY = new BlockFamily.Builder((Block)BlocksRegistration.WAX_BRICKS.get()).m_175988_((Block)BlocksRegistration.WAX_BRICK_STAIRS.get()).m_175986_((Block)BlocksRegistration.WAX_BRICK_SLAB.get()).m_175996_((Block)BlocksRegistration.WAX_BRICK_WALL.get()).m_175962_();
    public static final BlockFamily SMOOTH_WAX_FAMILY = new BlockFamily.Builder((Block)BlocksRegistration.SMOOTH_WAX.get()).m_175988_((Block)BlocksRegistration.SMOOTH_WAX_STAIRS.get()).m_175986_((Block)BlocksRegistration.SMOOTH_WAX_SLAB.get()).m_175996_((Block)BlocksRegistration.SMOOTH_WAX_WALL.get()).m_175971_((Block)BlocksRegistration.CHISELED_WAX.get()).m_175962_();

    public static void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BeeModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ParticleDescriptionGenerator(packOutput, existingFileHelper));
        BlockTagGenerator blockTagGenerator = new BlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagGenerator);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), pOutput -> new LootTableGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new BeeAdvancementGenerator(packOutput, lookupProvider, existingFileHelper));
        ComplicatedBees.LOGGER.info("combs: {}, flowers: {}, species: {}, mutations: {}", new Object[]{new Combs(), new Flowers(), new BuiltInSpecies(), new Mutations()});
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, new RegistrySetBuilder().m_254916_(CombRegistration.COMB_REGISTRY_KEY, bootstrap -> {
            for (Map.Entry<ResourceKey<Comb>, Comb> entry : BuiltIn.COMBS.entrySet()) {
                bootstrap.m_255272_(entry.getKey(), (Object)entry.getValue());
            }
        }).m_254916_(FlowerRegistration.FLOWER_REGISTRY_KEY, bootstrap -> {
            for (Map.Entry<ResourceKey<Flower>, Flower> entry : BuiltIn.FLOWERS.entrySet()) {
                bootstrap.m_255272_(entry.getKey(), (Object)entry.getValue());
            }
        }).m_254916_(SpeciesRegistration.SPECIES_REGISTRY_KEY, bootstrap -> {
            for (Map.Entry<ResourceKey<Species>, Species> entry : BuiltIn.SPECIES.entrySet()) {
                bootstrap.m_255272_(entry.getKey(), (Object)entry.getValue());
            }
        }).m_254916_(MutationRegistration.MUTATION_REGISTRY_KEY, bootstrap -> {
            Mutations.generateMutations();
            for (Map.Entry<ResourceKey<Mutation>, Mutation> entry : BuiltIn.MUTATIONS.entrySet()) {
                bootstrap.m_255272_(entry.getKey(), (Object)entry.getValue());
            }
        }), Set.of("complicated_bees")));
    }
}

