/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.datagen.builtin;

import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.GeneActiveTime;
import com.accbdd.complicated_bees.bees.gene.GeneBoolean;
import com.accbdd.complicated_bees.bees.gene.GeneEffect;
import com.accbdd.complicated_bees.bees.gene.GeneFertility;
import com.accbdd.complicated_bees.bees.gene.GeneFlower;
import com.accbdd.complicated_bees.bees.gene.GeneHumidity;
import com.accbdd.complicated_bees.bees.gene.GeneLifespan;
import com.accbdd.complicated_bees.bees.gene.GeneProductivity;
import com.accbdd.complicated_bees.bees.gene.GeneTemperature;
import com.accbdd.complicated_bees.bees.gene.GeneTerritory;
import com.accbdd.complicated_bees.bees.gene.enums.EnumActiveTime;
import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.gene.enums.EnumLifespan;
import com.accbdd.complicated_bees.bees.gene.enums.EnumProductivity;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.datagen.builtin.BuiltIn;
import com.accbdd.complicated_bees.datagen.builtin.Combs;
import com.accbdd.complicated_bees.datagen.builtin.Flowers;
import com.accbdd.complicated_bees.item.ExpDropItem;
import com.accbdd.complicated_bees.registry.BeeEffectRegistration;
import com.accbdd.complicated_bees.registry.GeneRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class BuiltInSpecies {
    public static final List<ResourceLocation> RED_MODELS = BuiltInSpecies.getModelList("red");
    public static final List<ResourceLocation> GRAY_MODELS = BuiltInSpecies.getModelList("gray");
    public static final List<ResourceLocation> ENDER_MODELS = BuiltInSpecies.getModelList("ender");
    public static final List<ResourceLocation> JAZZY_MODELS = BuiltInSpecies.getModelList("jazzy");
    public static final List<ResourceLocation> TRICKY_MODELS = BuiltInSpecies.getModelList("tricky");
    public static final Map.Entry<ResourceKey<Species>, Species> FOREST = BuiltIn.species(new Species.Builder(BuiltIn.loc("forest")).dominant(true).foil(false).colors(261352).products(List.of(new Product(BuiltIn.stack(Combs.HONEY), 0.35f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTEST, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWEST, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.DIURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(false, true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(false, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> PLAINS = BuiltIn.species(Species.Builder.of(FOREST.getValue(), BuiltIn.loc("plains")).colors(16515855, 13184258).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTER, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.UP_1, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> JUNGLE = BuiltIn.species(Species.Builder.of(FOREST.getValue(), BuiltIn.loc("jungle")).colors(8109828, 5206558).products(List.of(new Product(BuiltIn.stack(Combs.SILKY), 0.35f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.WET, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.JUNGLE.getKey().m_135782_(), true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.VENOMOUS.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> TANGLE = BuiltIn.species(Species.Builder.of(JUNGLE.getValue(), BuiltIn.loc("tangle")).colors(6593793).products(List.of(new Product(BuiltIn.stack(Combs.SILKY), 0.4f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTER, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(true, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> LUSH = BuiltIn.species(Species.Builder.of(TANGLE.getValue(), BuiltIn.loc("lush")).colors(10737989).products(List.of(new Product(BuiltIn.stack(Combs.SILKY), 0.45f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(true, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.POLLENIC.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> DESERT = BuiltIn.species(Species.Builder.of(FOREST.getValue(), BuiltIn.loc("desert")).colors(16768903).products(List.of(new Product(BuiltIn.stack(Combs.DUSTY), 0.35f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HOT, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.DRY, EnumTolerance.NONE, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DESERT.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NOCTURNAL, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> OUTCAST = BuiltIn.species(Species.Builder.of(DESERT.getValue(), BuiltIn.loc("outcast")).colors(16570994).products(List.of(new Product(BuiltIn.stack(Combs.DUSTY), 0.4f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> BANDIT = BuiltIn.species(Species.Builder.of(OUTCAST.getValue(), BuiltIn.loc("bandit")).colors(13462040).products(List.of(new Product(BuiltIn.stack(Combs.DUSTY), 0.4f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HOT, EnumTolerance.DOWN_2, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.TRIBUTE.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> ROCKY = BuiltIn.species(Species.Builder.of(FOREST.getValue(), BuiltIn.loc("rocky")).colors(0x7E7E7E, 10305899).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.35f))).models(GRAY_MODELS).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.LUSH_CAVE.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NOCTURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(true, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> ROBUST = BuiltIn.species(Species.Builder.of(ROCKY.getValue(), BuiltIn.loc("robust")).colors(0x999999).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.35f))).models(GRAY_MODELS).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.UP_1, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> RESILIENT = BuiltIn.species(Species.Builder.of(ROCKY.getValue(), BuiltIn.loc("resilient")).colors(0xB8B7B7).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.4f))).models(GRAY_MODELS).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.UP_1, false)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONG, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> COMMON = BuiltIn.species(Species.Builder.of(PLAINS.getValue(), BuiltIn.loc("common")).colors(0xC2C2C2).products(List.of(new Product(BuiltIn.stack(Combs.HONEY), 0.4f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CULTIVATED = BuiltIn.species(Species.Builder.of(COMMON.getValue(), BuiltIn.loc("cultivated")).colors(4539125).products(List.of(new Product(BuiltIn.stack(Combs.HONEY), 0.4f))).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> NOBLE = BuiltIn.species(new Species.Builder(BuiltIn.loc("noble")).dominant(false).foil(false).colors(16763448).products(List.of(new Product(BuiltIn.stack(Combs.DRIPPING), 0.4f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, false)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.NONE, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.DIURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(false, true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(false, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> MAJESTIC = BuiltIn.species(Species.Builder.of(NOBLE.getValue(), BuiltIn.loc("majestic")).colors(8651041).specialtyProducts(List.of(new Product(BuiltIn.stack(Combs.ROYAL), 0.25f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(3, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> IMPERIAL = BuiltIn.species(Species.Builder.of(MAJESTIC.getValue(), BuiltIn.loc("imperial")).colors(8651041).foil(true).products(List.of(new Product(BuiltIn.stack(Combs.DRIPPING), 0.5f))).specialtyProducts(List.of(new Product(BuiltIn.stack(Combs.ROYAL), 0.4f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(4, false)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.BEATIFIC.get(), false)));
    public static final Map.Entry<ResourceKey<Species>, Species> DILIGENT = BuiltIn.species(new Species.Builder(BuiltIn.loc("diligent")).colors(11944693).products(List.of(new Product(BuiltIn.stack(Combs.STRINGY), 0.35f), new Product(BuiltIn.stack(Combs.HONEY), 0.1f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, false)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.DIURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(false, true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(false, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> TIRELESS = BuiltIn.species(Species.Builder.of(DILIGENT.getValue(), BuiltIn.loc("tireless")).colors(5111432).products(List.of(new Product(BuiltIn.stack(Combs.STRINGY), 0.4f), new Product(BuiltIn.stack(Combs.HONEY), 0.1f))).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> INDUSTRIOUS = BuiltIn.species(Species.Builder.of(DILIGENT.getValue(), BuiltIn.loc("industrious")).colors(15530750).foil(true).products(List.of(new Product(BuiltIn.stack(Combs.STRINGY), 0.4f), new Product(BuiltIn.stack(Combs.HONEY), 0.1f))).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> EXPLORER = BuiltIn.species(new Species.Builder(BuiltIn.loc("explorer")).colors(7256064).dominant(false).foil(false).products(List.of(new Product(BuiltIn.stack(Combs.STRINGY), 0.4f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.UP_1, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, false)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.EXPLORER.get(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.CATHEMERAL, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> INTREPID = BuiltIn.species(Species.Builder.of(EXPLORER.getValue(), BuiltIn.loc("explorer")).colors(2804437).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_2, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.EFFECT, new GeneEffect()));
    public static final Map.Entry<ResourceKey<Species>, Species> CHAMPION = BuiltIn.species(Species.Builder.of(EXPLORER.getValue(), BuiltIn.loc("explorer")).colors(16636936).dominant(true).foil(true).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_2, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.BOTH_1, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.CHAMPION.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> ENDER = BuiltIn.species(new Species.Builder(BuiltIn.loc("ender")).colors(15829759, 8341884).dominant(true).foil(false).models(ENDER_MODELS).products(List.of(new Product(BuiltIn.stack(Combs.MYSTERIOUS), 0.25f))).specialtyProducts(List.of(new Product(((Item)ItemsRegistration.PEARL_SHARD.get()).m_7968_(), 0.05f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONG, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.COLD, EnumTolerance.UP_2, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, false)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.CHORUS.getKey().m_135782_(), true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.ENDS.get(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.CATHEMERAL, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> SURREAL = BuiltIn.species(Species.Builder.of(ENDER.getValue(), BuiltIn.loc("surreal")).colors(10100735).products(List.of(new Product(BuiltIn.stack(Combs.MYSTERIOUS), 0.3f))).specialtyProducts(List.of(new Product(((Item)ItemsRegistration.PEARL_SHARD.get()).m_7968_(), 0.1f))).gene(GeneRegistration.TERRITORY, new GeneTerritory(5, 3, true)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONGER, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> ENIGMATIC = BuiltIn.species(Species.Builder.of(ENDER.getValue(), BuiltIn.loc("enigmatic")).colors(3793).products(List.of(new Product(BuiltIn.stack(Combs.MYSTERIOUS), 0.35f))).specialtyProducts(List.of(new Product(((Item)ItemsRegistration.PEARL_SHARD.get()).m_7968_(), 0.1f), new Product(((ExpDropItem)((Object)ItemsRegistration.EXP_DROP.get())).m_7968_(), 0.25f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONGER, true)).gene(GeneRegistration.TERRITORY, new GeneTerritory(6, 3, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.ICY, EnumTolerance.UP_2, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> WARPED = BuiltIn.species(new Species.Builder(BuiltIn.loc("warped")).colors(1948087, 1353851).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.3f))).models(RED_MODELS).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTER, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HELLISH, EnumTolerance.NONE, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.NETHER.getKey().m_135782_(), true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.AGGRESSIVE.get(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.CATHEMERAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(true, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CRIMSON = BuiltIn.species(Species.Builder.of(WARPED.getValue(), BuiltIn.loc("crimson")).colors(0x990000, 11345435).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTEST, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CURSED = BuiltIn.species(Species.Builder.of(WARPED.getValue(), BuiltIn.loc("cursed")).colors(0x404040).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.35f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HELLISH, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.CURSED.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> HAUNTED = BuiltIn.species(Species.Builder.of(CURSED.getValue(), BuiltIn.loc("haunted")).dominant(false).colors(7617829).products(List.of(new Product(BuiltIn.stack(Combs.SPECTRAL), 0.35f), new Product(BuiltIn.stack(Combs.SIMMERING), 0.05f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, false)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.CURSED.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> GHOSTLY = BuiltIn.species(Species.Builder.of(HAUNTED.getValue(), BuiltIn.loc("ghostly")).colors(12775679).products(List.of(new Product(BuiltIn.stack(Combs.SPECTRAL), 0.35f), new Product(BuiltIn.stack(Combs.SIMMERING), 0.05f))).specialtyProducts(List.of(new Product(Items.f_42525_.m_7968_(), 0.05f))).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.SPECTRAL.get(), false)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(true, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.FAST, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> SPECTRAL = BuiltIn.species(Species.Builder.of(GHOSTLY.getValue(), BuiltIn.loc("spectral")).foil(true).colors(0xFFF700).products(List.of(new Product(BuiltIn.stack(Combs.SPECTRAL), 0.35f), new Product(BuiltIn.stack(Combs.SIMMERING), 0.05f))).specialtyProducts(List.of(new Product(Items.f_42525_.m_7968_(), 0.1f))).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.SPECTRAL.get(), true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(true, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.FASTER, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> FIENDISH = BuiltIn.species(Species.Builder.of(CURSED.getValue(), BuiltIn.loc("fiendish")).dominant(true).colors(12386361).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.35f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, false)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.FLAMING.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> DEVILISH = BuiltIn.species(Species.Builder.of(FIENDISH.getValue(), BuiltIn.loc("devilish")).colors(15073349).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.4f))).specialtyProducts(List.of(new Product(Items.f_42593_.m_7968_(), 0.1f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONG, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(3, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> INFERNAL = BuiltIn.species(Species.Builder.of(DEVILISH.getValue(), BuiltIn.loc("infernal")).colors(16711769).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.45f))).specialtyProducts(List.of(new Product(Items.f_42525_.m_7968_(), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONG, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(3, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.HOSTILE.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> DECAYING = BuiltIn.species(new Species.Builder(BuiltIn.loc("decaying")).colors(0x7E7700).dominant(false).products(List.of(new Product(BuiltIn.stack(Combs.ROTTEN), 0.4f), new Product(BuiltIn.stack(Combs.STRINGY), 0.1f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTER, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.COLD, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.BOTH_1, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.SKULLS.getKey().m_135782_(), true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.UNHEALTHY.get(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NEVER_SLEEPS, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> ROTTEN = BuiltIn.species(Species.Builder.of(DECAYING.getValue(), BuiltIn.loc("rotten")).colors(4875013).dominant(true).products(List.of(new Product(BuiltIn.stack(Combs.ROTTEN), 0.4f), new Product(BuiltIn.stack(Combs.STRINGY), 0.1f))).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.ICY, EnumTolerance.UP_2, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, false)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NEVER_SLEEPS, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> NECROMANTIC = BuiltIn.species(Species.Builder.of(ROTTEN.getValue(), BuiltIn.loc("necromantic")).foil(true).colors(4875013).dominant(false).products(List.of(new Product(BuiltIn.stack(Combs.ROTTEN), 0.4f), new Product(BuiltIn.stack(Combs.HONEY), 0.1f))).specialtyProducts(List.of(new Product(BuiltIn.stack(Combs.SPECTRAL), 0.2f))).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NEVER_SLEEPS, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.RESURRECTION.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> BITUMINOUS = BuiltIn.species(new Species.Builder(BuiltIn.loc("bituminous")).dominant(true).models(GRAY_MODELS).colors(0x141414).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.COAL), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORTER, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DEEPSLATE.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NOCTURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(true, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CONDUCTIVE = BuiltIn.species(Species.Builder.of(BITUMINOUS.getValue(), BuiltIn.loc("conductive")).colors(13173507).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.REDSTONE), 0.15f))).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.GRANITE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> LAPIC = BuiltIn.species(Species.Builder.of(BITUMINOUS.getValue(), BuiltIn.loc("lapic")).colors(3300091).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.LAPIS), 0.15f))).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DEEPSLATE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, true)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> DIMANTIC = BuiltIn.species(Species.Builder.of(BITUMINOUS.getValue(), BuiltIn.loc("dimantic")).dominant(false).colors(4381183).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.DIAMOND), 0.1f))).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.GRANITE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWEST, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, true)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> AMETHYST = BuiltIn.species(Species.Builder.of(BITUMINOUS.getValue(), BuiltIn.loc("amethyst")).colors(11158271).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.AMETHYST), 0.15f))).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.CALCITE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> EMERADIC = BuiltIn.species(Species.Builder.of(BITUMINOUS.getValue(), BuiltIn.loc("emeradic")).dominant(false).colors(1048427).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.EMERALD), 0.1f))).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.GRANITE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWER, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, false)).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> QUARTZ = BuiltIn.species(new Species.Builder(BuiltIn.loc("quartz")).dominant(true).models(RED_MODELS).colors(14211002).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.3f), new Product(BuiltIn.stack(Combs.QUARTZ), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HOT, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.DRY, EnumTolerance.UP_1, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DIORITE.getKey().m_135782_(), true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOW, true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.CATHEMERAL, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> LUMINOUS = BuiltIn.species(Species.Builder.of(QUARTZ.getValue(), BuiltIn.loc("luminous")).colors(16116992).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.3f), new Product(BuiltIn.stack(Combs.GLOWSTONE), 0.15f))).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.SPECTRAL.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CUPROUS = BuiltIn.species(new Species.Builder(BuiltIn.loc("cuprous")).dominant(true).models(GRAY_MODELS).colors(14523436).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.COPPER), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.NONE, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.AVERAGE, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.GRANITE.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.DIURNAL, true)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(true, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(3, false)));
    public static final Map.Entry<ResourceKey<Species>, Species> PRECIOUS = BuiltIn.species(Species.Builder.of(CUPROUS.getValue(), BuiltIn.loc("precious")).colors(15127040).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.GOLD), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DRIPSTONE.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> FERROUS = BuiltIn.species(Species.Builder.of(PRECIOUS.getValue(), BuiltIn.loc("ferrous")).colors(0xD1D1D1).products(List.of(new Product(BuiltIn.stack(Combs.ROCKY), 0.3f), new Product(BuiltIn.stack(Combs.IRON), 0.15f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.TUFF.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> ADAMANTINE = BuiltIn.species(new Species.Builder(BuiltIn.loc("adamantine")).dominant(false).foil(true).models(RED_MODELS).products(List.of(new Product(BuiltIn.stack(Combs.SIMMERING), 0.3f), new Product(Items.f_42419_.m_7968_(), 0.08f))).colors(5063997).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.AVERAGE, false)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.HOT, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.DRY, EnumTolerance.UP_1, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWEST, false)).gene(GeneRegistration.FERTILITY, new GeneFertility(1, true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DEBRIS.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.CATHEMERAL, false)).gene(GeneRegistration.CAVE_DWELLING, new GeneBoolean(true, true)).gene(GeneRegistration.WEATHERPROOF, new GeneBoolean(true, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> JAZZY = BuiltIn.species(new Species.Builder(BuiltIn.loc("jazzy")).dominant(false).foil(false).models(JAZZY_MODELS).colors(6726143).products(List.of(new Product(BuiltIn.stack(Combs.HONEY), 0.3f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.SHORT, true)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.COLD, EnumTolerance.UP_1, true)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.WET, EnumTolerance.DOWN_1, true)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWEST, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, false)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.MUSICAL.getKey().m_135782_(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.DIURNAL, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.JAZZY.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> ESSAYIST = BuiltIn.species(Species.Builder.of(JAZZY.getValue(), BuiltIn.loc("essayist")).colors(0xFFCC00).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.ESSAYIST.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> TRICKY = BuiltIn.species(Species.Builder.of(JAZZY.getValue(), BuiltIn.loc("tricky")).colors(0xFFFFFF).models(TRICKY_MODELS).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.FASTER, true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NEVER_SLEEPS, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.TRICKY.get(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> PRIMORDIAL = BuiltIn.species(new Species.Builder(BuiltIn.loc("primordial")).dominant(false).foil(true).colors(0xFFFFFF).models(BuiltInSpecies.getModelList("primordial")).products(List.of(new Product(BuiltIn.stack(Combs.MYSTERIOUS), 0.25f))).gene(GeneRegistration.LIFESPAN, new GeneLifespan(EnumLifespan.LONGEST, false)).gene(GeneRegistration.TEMPERATURE, new GeneTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_2, false)).gene(GeneRegistration.HUMIDITY, new GeneHumidity(EnumHumidity.NORMAL, EnumTolerance.BOTH_1, false)).gene(GeneRegistration.PRODUCTIVITY, new GeneProductivity(EnumProductivity.SLOWEST, true)).gene(GeneRegistration.FERTILITY, new GeneFertility(2, false)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DRAGON_EGG.getKey().m_135782_(), false)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.ENDS.get(), true)).gene(GeneRegistration.ACTIVE_TIME, new GeneActiveTime(EnumActiveTime.NEVER_SLEEPS, false)).gene(GeneRegistration.TERRITORY, new GeneTerritory(7, 4, true)));
    public static final Map.Entry<ResourceKey<Species>, Species> CAMPESTRAL = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("campestral")).dominant(true).foil(false).colors(16515855).models(BuiltInSpecies.getModelList("plains_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.PLAINS_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> SYLVAN = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("sylvan")).dominant(true).foil(false).colors(261352).models(BuiltInSpecies.getModelList("forest_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.FOREST_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> BOREAL = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("boreal")).dominant(true).foil(false).colors(5389336).models(BuiltInSpecies.getModelList("taiga_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.TAIGA_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.FLOWER.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> TROPIC = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("tropic")).dominant(true).foil(false).colors(2995456).models(BuiltInSpecies.getModelList("jungle_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.JUNGLE_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.JUNGLE.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> PALUDAL = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("paludal")).dominant(true).foil(false).colors(0x444724).models(BuiltInSpecies.getModelList("swamp_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.SWAMP_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.SWAMP.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> GELID = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("gelid")).dominant(true).foil(false).models(BuiltInSpecies.getModelList("snowy_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.SNOWY_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.ICY.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> MYCELIC = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("mycelic")).dominant(true).foil(false).colors(13408632).models(BuiltInSpecies.getModelList("mushroom_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.MUSHROOM_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.MYCELIC.getKey().m_135782_(), true)));
    public static final Map.Entry<ResourceKey<Species>, Species> XERIC = BuiltIn.species(Species.Builder.of(PRIMORDIAL.getValue(), BuiltIn.loc("xeric")).dominant(true).foil(false).colors(12238741).models(BuiltInSpecies.getModelList("desert_terraform")).gene(GeneRegistration.TERRITORY, new GeneTerritory(9, 5, true)).gene(GeneRegistration.EFFECT, new GeneEffect(BeeEffectRegistration.DESERT_TERRAFORM.get(), true)).gene(GeneRegistration.FLOWER, new GeneFlower(Flowers.DESERT.getKey().m_135782_(), true)));

    private static List<ResourceLocation> getModelList(String name) {
        return List.of(BuiltIn.loc("item/" + name + "_drone"), BuiltIn.loc("item/" + name + "_princess"), BuiltIn.loc("item/" + name + "_queen"));
    }
}

