/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.item;

import com.accbdd.complicated_bees.bees.Chromosome;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.GeneFlower;
import com.accbdd.complicated_bees.bees.gene.GeneHumidity;
import com.accbdd.complicated_bees.bees.gene.GeneLifespan;
import com.accbdd.complicated_bees.bees.gene.GeneProductivity;
import com.accbdd.complicated_bees.bees.gene.GeneSpecies;
import com.accbdd.complicated_bees.bees.gene.GeneTemperature;
import com.accbdd.complicated_bees.bees.gene.GeneTolerant;
import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeItem
extends Item {
    public static final String AGE_TAG = "bee_age";
    public static final String ANALYZED_TAG = "analyzed";

    public BeeItem(Item.Properties prop) {
        super(prop);
    }

    public boolean m_5812_(ItemStack pStack) {
        return GeneticHelper.getSpecies(pStack, true).isFoil();
    }

    public static float getAge(ItemStack stack) {
        return stack.m_41784_().m_128457_(AGE_TAG);
    }

    public static void setAge(ItemStack stack, float age) {
        stack.m_41784_().m_128350_(AGE_TAG, age);
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        Species primary = GeneticHelper.getSpecies(stack, true);
        MutableComponent component = Component.m_237119_();
        component.m_7220_((Component)GeneticHelper.getTranslationKey(primary));
        if (primary == null) {
            return component;
        }
        component.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)this.m_5524_()));
        if (BreedingTracker.CLIENT_INSTANCE != null && !BreedingTracker.CLIENT_INSTANCE.isDiscovered(GeneticHelper.getSpecies(stack, true))) {
            component.m_130940_(ChatFormatting.ITALIC);
        }
        return component;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            Species species = GeneticHelper.getSpecies(stack, true);
            if (species != null) {
                return species.getColor();
            }
            return 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level pLevel, @NotNull List<Component> components, @NotNull TooltipFlag isAdvanced) {
        GeneSpecies geneSpecies = (GeneSpecies)GeneticHelper.getGene(stack, new ResourceLocation("complicated_bees", "species"), true);
        if (geneSpecies == null) {
            components.add((Component)Component.m_237113_((String)"INVALID ITEM"));
        } else if (geneSpecies.get() == null) {
            components.add((Component)Component.m_237113_((String)"INVALID SPECIES"));
        } else if (!stack.m_41784_().m_128471_(ANALYZED_TAG)) {
            components.add((Component)Component.m_237115_((String)"gui.complicated_bees.not_analyzed").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        } else if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"gui.complicated_bees.more_info").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        } else if (Minecraft.m_91087_().f_91073_ != null) {
            Chromosome primary = GeneticHelper.getChromosome(stack, true);
            MutableComponent hybridName = GeneticHelper.getSpeciesHybridName(stack);
            if (hybridName != null) {
                components.add((Component)hybridName.m_130940_(ChatFormatting.BLUE));
            }
            components.add((Component)primary.getGene(GeneLifespan.ID).getTranslationKey().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gene.complicated_bees.lifespan_label")).m_130940_(ChatFormatting.GRAY));
            components.add((Component)primary.getGene(GeneProductivity.ID).getTranslationKey().m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gene.complicated_bees.productivity_label.short")).m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"gene.complicated_bees.temperature_label.short").m_130946_(": ").m_7220_((Component)primary.getGene(GeneTemperature.ID).getTranslationKey()).m_130946_(" / ").m_7220_(((GeneTolerant)primary.getGene(GeneTemperature.ID)).getTolerance().getTranslationKey()).m_130940_(ChatFormatting.GREEN));
            components.add((Component)Component.m_237115_((String)"gene.complicated_bees.humidity_label.short").m_130946_(": ").m_7220_((Component)((EnumHumidity)((Object)primary.getGene(GeneHumidity.ID).get())).getTranslationKey()).m_130946_(" / ").m_7220_(((GeneTolerant)primary.getGene(GeneHumidity.ID)).getTolerance().getTranslationKey()).m_130940_(ChatFormatting.GREEN));
            components.add((Component)primary.getGene(GeneFlower.ID).getTranslationKey().m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, pLevel, components, isAdvanced);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pLevel.m_5776_() && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BreedingTracker.getTracker(player).discoverIndividual(pStack);
        }
    }
}

