/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.multiblock;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.block.MellariumBlock;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumAbstractBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumControllerBlockEntity;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.util.BlockPosBoxIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class MellariumLogic {
    private final Level level;
    private final BlockPos center;
    private final List<BlockPos> specialBlocks = new ArrayList<BlockPos>();
    private UUID owner;

    public MellariumLogic(Level level, BlockPos center, UUID owner) {
        this.level = level;
        this.center = center;
        this.owner = owner;
        BlockPosBoxIterator iterator = new BlockPosBoxIterator(center, 1, 1);
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MellariumAbstractBlockEntity) {
                MellariumAbstractBlockEntity mellariumBlock = (MellariumAbstractBlockEntity)blockEntity;
                mellariumBlock.setLogic(this);
                if (level.m_8055_(pos).m_60713_((Block)BlocksRegistration.MELLARIUM_BASE.get())) continue;
                this.specialBlocks.add(pos);
                continue;
            }
            blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MellariumControllerBlockEntity) {
                MellariumControllerBlockEntity controller = (MellariumControllerBlockEntity)blockEntity;
                controller.setMellariumLogic(this);
                controller.setOwner(owner);
                continue;
            }
            ComplicatedBees.LOGGER.warn("built a mellarium with non-mellarium block at {}", (Object)pos);
        }
    }

    public void deconstruct(BlockPos pos) {
        BlockPosBoxIterator iterator = new BlockPosBoxIterator(this.center, 1, 1);
        if (this.getController() != null) {
            while (this.getController() != null && !this.getController().getOutputBuffer().empty()) {
                Containers.m_18992_((Level)this.level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getController().getOutputBuffer().pop());
            }
            IItemHandler handler = (IItemHandler)this.getController().getItemHandler().orElseThrow(() -> new RuntimeException("no item handler found!"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                Containers.m_18992_((Level)this.level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
            }
        }
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            BlockEntity blockEntity = this.level.m_7702_(p);
            if (!(blockEntity instanceof MellariumAbstractBlockEntity)) continue;
            MellariumAbstractBlockEntity mellariumBlock = (MellariumAbstractBlockEntity)blockEntity;
            mellariumBlock.setLogic(null);
        }
        this.level.m_7731_(this.center, (BlockState)((MellariumBlock)((Object)BlocksRegistration.MELLARIUM_BASE.get())).m_49966_().m_61124_(EsotericRegistration.ASSEMBLED, (Comparable)((Object)EsotericRegistration.AssembledStatus.none)), 3);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public MellariumControllerBlockEntity getController() {
        BlockEntity blockEntity = this.level.m_7702_(this.center);
        if (blockEntity instanceof MellariumControllerBlockEntity) {
            MellariumControllerBlockEntity controller = (MellariumControllerBlockEntity)blockEntity;
            return controller;
        }
        return null;
    }

    public List<BlockPos> getSpecialBlocks() {
        return this.specialBlocks;
    }
}

