/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.registry;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.config.Config;
import com.accbdd.complicated_bees.item.AnalyzerItem;
import com.accbdd.complicated_bees.item.ArmorMaterials;
import com.accbdd.complicated_bees.item.BeeNestBlockItem;
import com.accbdd.complicated_bees.item.BeeStaffItem;
import com.accbdd.complicated_bees.item.BeeswaxItem;
import com.accbdd.complicated_bees.item.CombItem;
import com.accbdd.complicated_bees.item.DisableableItem;
import com.accbdd.complicated_bees.item.DroneItem;
import com.accbdd.complicated_bees.item.ExpDropItem;
import com.accbdd.complicated_bees.item.FrameItem;
import com.accbdd.complicated_bees.item.MeterItem;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.item.ScoopItem;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemsRegistration {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"complicated_bees");
    public static final List<RegistryObject<? extends Item>> CREATIVE_TAB_ITEMS = new ArrayList<RegistryObject<? extends Item>>();
    public static final RegistryObject<DroneItem> DRONE = ITEMS.register("drone", () -> new DroneItem(new Item.Properties()));
    public static final RegistryObject<PrincessItem> PRINCESS = ITEMS.register("princess", () -> new PrincessItem(new Item.Properties()));
    public static final RegistryObject<QueenItem> QUEEN = ITEMS.register("queen", () -> new QueenItem(new Item.Properties()));
    public static final RegistryObject<CombItem> COMB = ITEMS.register("comb", () -> new CombItem(new Item.Properties()));
    public static final RegistryObject<Item> BEE_NEST = ITEMS.register("bee_nest", () -> new BeeNestBlockItem(new Item.Properties()));
    public static final RegistryObject<ScoopItem> SCOOP = ItemsRegistration.register("scoop", () -> new ScoopItem(new Item.Properties()));
    public static final RegistryObject<MeterItem> METER = ItemsRegistration.register("meter", () -> new MeterItem(new Item.Properties()));
    public static final RegistryObject<AnalyzerItem> ANALYZER = ItemsRegistration.register("analyzer", () -> new AnalyzerItem(new Item.Properties()));
    public static final RegistryObject<ExpDropItem> EXP_DROP = ItemsRegistration.register("exp_drop", () -> new ExpDropItem(new Item.Properties()));
    public static final RegistryObject<BeeswaxItem> BEESWAX = ItemsRegistration.register("beeswax", () -> new BeeswaxItem(new Item.Properties()));
    public static final RegistryObject<Item> HONEY_DROPLET = ItemsRegistration.registerSimpleItem("honey_droplet");
    public static final RegistryObject<Item> ROYAL_JELLY = ItemsRegistration.registerSimpleItem("royal_jelly");
    public static final RegistryObject<Item> POLLEN = ItemsRegistration.registerSimpleItem("pollen");
    public static final RegistryObject<Item> PROPOLIS = ItemsRegistration.registerSimpleItem("propolis");
    public static final RegistryObject<Item> SILK_WISP = ItemsRegistration.registerSimpleItem("silk_wisp");
    public static final RegistryObject<Item> WOVEN_MESH = ItemsRegistration.registerSimpleItem("woven_mesh");
    public static final RegistryObject<Item> PEARL_SHARD = ItemsRegistration.registerSimpleItem("pearl_shard");
    public static final RegistryObject<Item> WAXED_STICK = ItemsRegistration.registerSimpleItem("waxed_stick");
    public static final RegistryObject<Item> HONEYED_STICK = ItemsRegistration.registerSimpleItem("honeyed_stick");
    public static final RegistryObject<Item> MELLARIUM_PANEL = ItemsRegistration.registerSimpleItem("mellarium_panel");
    public static final RegistryObject<Item> BEE_STAFF = ItemsRegistration.register("bee_staff", () -> new BeeStaffItem(new Item.Properties(), Config.CONFIG.beeStaff));
    public static final RegistryObject<Item> HONEY_BREAD = ItemsRegistration.register("honey_bread", () -> new DisableableItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(0.4f).m_38767_()), Config.CONFIG.honeyBread));
    public static final RegistryObject<Item> HONEY_PORKCHOP = ItemsRegistration.register("honey_porkchop", () -> new DisableableItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(12).m_38758_(0.5f).m_38767_()), Config.CONFIG.honeyPorkchop));
    public static final RegistryObject<Item> AMBROSIA = ItemsRegistration.register("ambrosia", () -> new DisableableItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(1.2f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 400, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19603_, 1200, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19617_, 2400, 1), 1.0f).m_38765_().m_38767_()).m_41497_(Rarity.RARE), (ForgeConfigSpec.ConfigValue)Config.CONFIG.ambrosia){

        public boolean m_5812_(ItemStack pStack) {
            return true;
        }
    });
    public static final RegistryObject<FrameItem> FRAME = ItemsRegistration.register("frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().productivity(1.25f).build(), Config.CONFIG.frame));
    public static final RegistryObject<FrameItem> WAXED_FRAME = ItemsRegistration.register("waxed_frame", () -> new FrameItem(new Item.Properties().m_41503_(240), new BeeHousingModifier.Builder().productivity(1.5f).build(), Config.CONFIG.waxedFrame));
    public static final RegistryObject<FrameItem> HONEYED_FRAME = ItemsRegistration.register("honeyed_frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().productivity(1.75f).lifespan(0.9f).build(), Config.CONFIG.honeyFrame));
    public static final RegistryObject<FrameItem> TWISTING_FRAME = ItemsRegistration.register("twisting_frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().productivity(0.6f).lifespan(0.75f).mutation(1.25f).build(), Config.CONFIG.twistingFrame));
    public static final RegistryObject<FrameItem> SOOTHING_FRAME = ItemsRegistration.register("soothing_frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().productivity(0.75f).lifespan(1.5f).mutation(0.8f).build(), Config.CONFIG.soothingFrame));
    public static final RegistryObject<FrameItem> COLD_FRAME = ItemsRegistration.register("cold_frame", () -> new FrameItem(new Item.Properties().m_41503_(60), new BeeHousingModifier.Builder().temperature(EnumTolerance.DOWN_1).lifespan(0.6f).build(), Config.CONFIG.coldFrame));
    public static final RegistryObject<FrameItem> HOT_FRAME = ItemsRegistration.register("hot_frame", () -> new FrameItem(new Item.Properties().m_41503_(60), new BeeHousingModifier.Builder().temperature(EnumTolerance.UP_1).lifespan(0.6f).build(), Config.CONFIG.hotFrame));
    public static final RegistryObject<FrameItem> DRY_FRAME = ItemsRegistration.register("dry_frame", () -> new FrameItem(new Item.Properties().m_41503_(60), new BeeHousingModifier.Builder().humidity(EnumTolerance.DOWN_1).lifespan(0.8f).build(), Config.CONFIG.dryFrame));
    public static final RegistryObject<FrameItem> WET_FRAME = ItemsRegistration.register("wet_frame", () -> new FrameItem(new Item.Properties().m_41503_(60), new BeeHousingModifier.Builder().humidity(EnumTolerance.UP_1).lifespan(0.8f).build(), Config.CONFIG.wetFrame));
    public static final RegistryObject<FrameItem> DEADLY_FRAME = ItemsRegistration.register("deadly_frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().lifespan(0.1f).build(), Config.CONFIG.deadlyFrame));
    public static final RegistryObject<FrameItem> RESTRICTIVE_FRAME = ItemsRegistration.register("restrictive_frame", () -> new FrameItem(new Item.Properties().m_41503_(80), new BeeHousingModifier.Builder().territory(0.5f).lifespan(0.75f).productivity(0.75f).build(), Config.CONFIG.restrictiveFrame));
    public static final RegistryObject<ArmorItem> APIARIST_HELMET = ItemsRegistration.register("apiarist_helmet", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.APIARIST, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<ArmorItem> APIARIST_CHESTPLATE = ItemsRegistration.register("apiarist_chestplate", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.APIARIST, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<ArmorItem> APIARIST_LEGGINGS = ItemsRegistration.register("apiarist_leggings", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.APIARIST, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<ArmorItem> APIARIST_BOOTS = ItemsRegistration.register("apiarist_boots", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.APIARIST, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final RegistryObject<Item> APIARY = ItemsRegistration.registerSimpleBlockItem("apiary", BlocksRegistration.APIARY);
    public static final RegistryObject<Item> CENTRIFUGE = ItemsRegistration.registerSimpleBlockItem("centrifuge", BlocksRegistration.CENTRIFUGE);
    public static final RegistryObject<Item> GENERATOR = ItemsRegistration.registerSimpleBlockItem("generator", BlocksRegistration.GENERATOR);
    public static final RegistryObject<Item> MICROSCOPE = ItemsRegistration.registerSimpleBlockItem("microscope", BlocksRegistration.MICROSCOPE);
    public static final RegistryObject<Item> BEE_SORTER = ItemsRegistration.registerSimpleBlockItem("bee_sorter", BlocksRegistration.BEE_SORTER);
    public static final RegistryObject<Item> MELLARIUM_BASE = ItemsRegistration.registerSimpleBlockItem("mellarium_base", BlocksRegistration.MELLARIUM_BASE);
    public static final RegistryObject<Item> MELLARIUM_TEMP_UNIT = ItemsRegistration.registerSimpleBlockItem("mellarium_temp_unit", BlocksRegistration.MELLARIUM_TEMP_UNIT);
    public static final RegistryObject<Item> MELLARIUM_RAIN_SHIELD = ItemsRegistration.registerSimpleBlockItem("mellarium_rain_shield", BlocksRegistration.MELLARIUM_RAIN_SHIELD);
    public static final RegistryObject<Item> MELLARIUM_FRAME_HOUSING_1 = ItemsRegistration.registerSimpleBlockItem("mellarium_frame_housing_1", BlocksRegistration.MELLARIUM_FRAME_HOUSING_1);
    public static final RegistryObject<Item> MELLARIUM_FRAME_HOUSING_2 = ItemsRegistration.registerSimpleBlockItem("mellarium_frame_housing_2", BlocksRegistration.MELLARIUM_FRAME_HOUSING_2);
    public static final RegistryObject<Item> MELLARIUM_FRAME_HOUSING_3 = ItemsRegistration.registerSimpleBlockItem("mellarium_frame_housing_3", BlocksRegistration.MELLARIUM_FRAME_HOUSING_3);
    public static final RegistryObject<Item> MELLARIUM_MUTATOR = ItemsRegistration.registerSimpleBlockItem("mellarium_mutator", BlocksRegistration.MELLARIUM_MUTATOR);
    public static final RegistryObject<Item> MELLARIUM_HYDROREGULATOR = ItemsRegistration.registerSimpleBlockItem("mellarium_hydroregulator", BlocksRegistration.MELLARIUM_HYDROREGULATOR);
    public static final RegistryObject<Item> APID_LIBRARY = ItemsRegistration.registerSimpleBlockItem("apid_library", BlocksRegistration.APID_LIBRARY);
    public static final RegistryObject<Item> WAX_BLOCK = ItemsRegistration.registerSimpleBlockItem("wax_block", BlocksRegistration.WAX_BLOCK);
    public static final RegistryObject<Item> WAX_BLOCK_STAIRS = ItemsRegistration.registerSimpleBlockItem("wax_block_stairs", BlocksRegistration.WAX_BLOCK_STAIRS);
    public static final RegistryObject<Item> WAX_BLOCK_SLAB = ItemsRegistration.registerSimpleBlockItem("wax_block_slab", BlocksRegistration.WAX_BLOCK_SLAB);
    public static final RegistryObject<Item> WAX_BLOCK_WALL = ItemsRegistration.registerSimpleBlockItem("wax_block_wall", BlocksRegistration.WAX_BLOCK_WALL);
    public static final RegistryObject<Item> SMOOTH_WAX = ItemsRegistration.registerSimpleBlockItem("smooth_wax", BlocksRegistration.SMOOTH_WAX);
    public static final RegistryObject<Item> SMOOTH_WAX_STAIRS = ItemsRegistration.registerSimpleBlockItem("smooth_wax_stairs", BlocksRegistration.SMOOTH_WAX_STAIRS);
    public static final RegistryObject<Item> SMOOTH_WAX_SLAB = ItemsRegistration.registerSimpleBlockItem("smooth_wax_slab", BlocksRegistration.SMOOTH_WAX_SLAB);
    public static final RegistryObject<Item> SMOOTH_WAX_WALL = ItemsRegistration.registerSimpleBlockItem("smooth_wax_wall", BlocksRegistration.SMOOTH_WAX_WALL);
    public static final RegistryObject<Item> WAX_BRICKS = ItemsRegistration.registerSimpleBlockItem("wax_bricks", BlocksRegistration.WAX_BRICKS);
    public static final RegistryObject<Item> WAX_BRICK_STAIRS = ItemsRegistration.registerSimpleBlockItem("wax_brick_stairs", BlocksRegistration.WAX_BRICK_STAIRS);
    public static final RegistryObject<Item> WAX_BRICK_SLAB = ItemsRegistration.registerSimpleBlockItem("wax_brick_slab", BlocksRegistration.WAX_BRICK_SLAB);
    public static final RegistryObject<Item> WAX_BRICK_WALL = ItemsRegistration.registerSimpleBlockItem("wax_brick_wall", BlocksRegistration.WAX_BRICK_WALL);
    public static final RegistryObject<Item> CHISELED_WAX = ItemsRegistration.registerSimpleBlockItem("chiseled_wax", BlocksRegistration.CHISELED_WAX);
    public static final RegistryObject<Item> HONEYED_PLANKS = ItemsRegistration.registerSimpleBlockItem("honeyed_planks", BlocksRegistration.HONEYED_PLANKS);
    public static final RegistryObject<Item> HONEYED_STAIRS = ItemsRegistration.registerSimpleBlockItem("honeyed_stairs", BlocksRegistration.HONEYED_STAIRS);
    public static final RegistryObject<Item> HONEYED_SLAB = ItemsRegistration.registerSimpleBlockItem("honeyed_slab", BlocksRegistration.HONEYED_SLAB);
    public static final RegistryObject<Item> HONEYED_FENCE = ItemsRegistration.registerSimpleBlockItem("honeyed_fence", BlocksRegistration.HONEYED_FENCE);
    public static final RegistryObject<Item> HONEYED_FENCE_GATE = ItemsRegistration.registerSimpleBlockItem("honeyed_fence_gate", BlocksRegistration.HONEYED_FENCE_GATE);
    public static final RegistryObject<Item> HONEYED_BUTTON = ItemsRegistration.registerSimpleBlockItem("honeyed_button", BlocksRegistration.HONEYED_BUTTON);
    public static final RegistryObject<Item> HONEYED_PRESSURE_PLATE = ItemsRegistration.registerSimpleBlockItem("honeyed_pressure_plate", BlocksRegistration.HONEYED_PRESSURE_PLATE);
    public static final RegistryObject<BlockItem> HONEYED_DOOR = ItemsRegistration.register("honeyed_door", () -> new DoubleHighBlockItem((Block)BlocksRegistration.HONEYED_DOOR.get(), new Item.Properties()));
    public static final RegistryObject<Item> HONEYED_TRAPDOOR = ItemsRegistration.registerSimpleBlockItem("honeyed_trapdoor", BlocksRegistration.HONEYED_TRAPDOOR);
    public static final RegistryObject<Item> HONEYED_SIGN = ItemsRegistration.register("honeyed_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)BlocksRegistration.HONEYED_SIGN.get(), (Block)BlocksRegistration.HONEYED_WALL_SIGN.get()));
    public static final RegistryObject<Item> HONEYED_HANGING_SIGN = ItemsRegistration.register("honeyed_hanging_sign", () -> new HangingSignItem((Block)BlocksRegistration.HONEYED_HANGING_SIGN.get(), (Block)BlocksRegistration.HONEYED_WALL_HANGING_SIGN.get(), new Item.Properties().m_41487_(16)));

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> itemSupplier) {
        RegistryObject register = ITEMS.register(name, itemSupplier);
        CREATIVE_TAB_ITEMS.add((RegistryObject<? extends Item>)register);
        return register;
    }

    private static RegistryObject<Item> registerSimpleItem(String name) {
        return ItemsRegistration.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<Item> registerSimpleBlockItem(String name, RegistryObject<T> block) {
        return ItemsRegistration.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

