/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen;

import com.accbdd.complicated_bees.block.entity.mellarium.MellariumAbstractBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumControllerBlockEntity;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MenuRegistration;
import com.accbdd.complicated_bees.screen.AbstractBaseInventoryMenu;
import com.accbdd.complicated_bees.screen.slot.ItemSlot;
import com.accbdd.complicated_bees.screen.slot.OutputSlot;
import com.accbdd.complicated_bees.screen.slot.TagSlot;
import com.accbdd.complicated_bees.util.MultiblockHelper;
import com.accbdd.complicated_bees.util.enums.EnumErrorCodes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class MellariumMenu
extends AbstractBaseInventoryMenu {
    private final BlockPos pos;
    private final ContainerData data;
    private static final int INV_X = 8;
    private static final int INV_Y = 105;

    public MellariumMenu(int windowId, Player player, BlockPos pos) {
        this(windowId, player, pos, (ContainerData)new SimpleContainerData(3));
    }

    public MellariumMenu(int windowId, Player player, BlockPos pos, ContainerData data) {
        super(MenuRegistration.MELLARIUM_MENU.get(), windowId, player, 9, 8, 105);
        this.data = data;
        this.pos = pos;
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof MellariumAbstractBlockEntity) {
            MellariumAbstractBlockEntity blockEntity2 = (MellariumAbstractBlockEntity)blockEntity;
            MellariumControllerBlockEntity mellarium = blockEntity2.getLogic() != null ? blockEntity2.getLogic().getController() : MultiblockHelper.tryBuildMellarium(player.m_9236_(), pos, player.m_20148_()).getController();
            this.m_38897_((Slot)new TagSlot((IItemHandler)mellarium.getBeeItems(), 0, 29, 38, ItemTagGenerator.ROYAL));
            this.m_38897_((Slot)new ItemSlot((IItemHandler)mellarium.getBeeItems(), 1, 29, 63, (Item)ItemsRegistration.DRONE.get()));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 0, 115, 51));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 1, 115, 26));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 2, 137, 39));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 3, 137, 64));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 4, 115, 76));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 5, 93, 64));
            this.m_38897_((Slot)new OutputSlot((IItemHandler)mellarium.getOutputItems(), 6, 93, 39));
        }
        this.layoutPlayerInventorySlots((Container)player.m_150109_());
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return (Boolean)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.pos).m_6721_((level, pos1) -> !level.m_8055_(pos1).m_60713_(Blocks.f_50016_)).get() != false && player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    public boolean hasQueen() {
        ItemStack item = this.m_38853_(0).m_7993_();
        return item.m_41720_() == ItemsRegistration.QUEEN.get();
    }

    public int getScaledProgress(float progress, int maxProgress) {
        int barHeight = 45;
        return maxProgress != 0 && progress != 0.0f ? (int)(progress * (float)barHeight / (float)maxProgress) : 0;
    }

    public ItemStack getQueen() {
        return this.m_38853_(0).m_7993_();
    }

    public boolean isBreeding() {
        return this.data.m_6413_(0) > 0;
    }

    public ContainerData getData() {
        return this.data;
    }

    public boolean hasQueue() {
        return this.data.m_6413_(2) == EnumErrorCodes.OUTPUT_FULL.value;
    }
}

