/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen;

import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameClientbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeHintServerbound;
import com.accbdd.complicated_bees.screen.MicroscopeMenu;
import com.accbdd.complicated_bees.screen.widget.microscope.ConnectWiresGame;
import com.accbdd.complicated_bees.screen.widget.microscope.IMicroscopeGame;
import com.accbdd.complicated_bees.util.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MicroscopeScreen
extends AbstractContainerScreen<MicroscopeMenu> {
    private static final ResourceLocation GUI = new ResourceLocation("complicated_bees", "textures/gui/microscope/base.png");
    private IMicroscopeGame game = null;
    private PlainTextButton startButton;
    private AnalyzeButton analyzeButton;

    public MicroscopeScreen(MicroscopeMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 248;
        this.f_97727_ = 216;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent text = Component.m_237115_((String)"gui.complicated_bees.microscope.start").m_130940_(ChatFormatting.WHITE);
        int textWidth = this.f_96547_.m_92852_((FormattedText)text) + 10;
        this.analyzeButton = new AnalyzeButton(this.f_97735_ + 225, this.f_97736_ + 26, 16, 12, 0, 216, GUI, button -> {
            if (this.game != null && ((MicroscopeMenu)this.f_97732_).canSendHint()) {
                PacketHandler.CHANNEL.sendToServer((Object)new MicroscopeHintServerbound());
            }
        });
        int n = this.f_97735_ + 8 + 107 - textWidth / 2;
        Objects.requireNonNull(this.f_96547_);
        this.startButton = new PlainTextButton(n, this.f_97736_ + 50, textWidth, 9 + 8, (Component)text, pButton -> this.startGame(), Minecraft.m_91087_().f_91062_, (Component)text){
            private float animCount;
            final /* synthetic */ Component val$text;
            {
                this.val$text = component;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }

            public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                this.animCount += pPartialTick;
                this.animCount %= 40.0f;
                GuiHelper.drawBorderedRectangle(pGuiGraphics, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 1, this.m_198029_() ? -1 : -16711936, this.animCount > 20.0f ? -16724992 : 0x6600CC00);
                pGuiGraphics.m_280430_(MicroscopeScreen.this.f_96547_, this.val$text, this.m_252754_() + 5, this.m_252907_() + 5, 0xFFFFFF | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }
        };
        this.m_142416_((GuiEventListener)this.startButton);
        this.m_142416_((GuiEventListener)this.analyzeButton);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.analyzeButton.m_274382_()) {
            this.analyzeButton.clicked = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.analyzeButton.clicked = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        graphics.m_280218_(GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mousex, int mousey, float partialTick) {
        super.m_88315_(graphics, mousex, mousey, partialTick);
        this.startButton.f_93624_ = this.game == null;
        this.renderText(graphics);
        this.renderSlotOverlays(graphics);
        this.m_280072_(graphics, mousex, mousey);
    }

    public void renderText(GuiGraphics graphics) {
        if (this.game == null) {
            graphics.m_280168_().m_85836_();
            PoseStack poseStack = graphics.m_280168_();
            float f = this.f_97735_ + 8;
            Objects.requireNonNull(this.f_96547_);
            poseStack.m_252880_(f, (float)(this.f_97736_ + 8 - 9 / 2), 0.0f);
            MutableComponent pText = null;
            if (((MicroscopeMenu)this.f_97732_).researchedMutationsCount == -1) {
                pText = Component.m_237115_((String)"gui.complicated_bees.microscope.place");
            } else if (((MicroscopeMenu)this.f_97732_).possibleMutationsCount == ((MicroscopeMenu)this.f_97732_).researchedMutationsCount || ((MicroscopeMenu)this.f_97732_).possibleMutationsCount == 0) {
                pText = Component.m_237115_((String)"gui.complicated_bees.microscope.complete").m_130940_(ChatFormatting.GREEN);
            }
            this.startButton.m_253211_(this.f_97736_ + GuiHelper.drawCenteredWrappedText(graphics, 107, 60, 0xFFFFFF, 12, 215, 3, new Component[]{((MicroscopeMenu)this.f_97732_).researchedMutationsCount > -1 ? Component.m_237110_((String)"gui.complicated_bees.microscope.mutation_count", (Object[])new Object[]{((MicroscopeMenu)this.m_6262_()).researchedMutationsCount, ((MicroscopeMenu)this.m_6262_()).possibleMutationsCount}) : null, pText, ((MicroscopeMenu)this.f_97732_).researchedMutationsCount < ((MicroscopeMenu)this.f_97732_).possibleMutationsCount ? Component.m_237119_() : null}));
            this.startButton.f_93624_ = pText == null;
            graphics.m_280168_().m_85849_();
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mousex, int mousey) {
    }

    public void renderSlotOverlays(GuiGraphics graphics) {
        graphics.m_280218_(GUI, this.f_97735_ + 225, this.f_97736_ + 8, 0, 240, 16, 16);
        for (int i = 0; i < 5; ++i) {
            if (((MicroscopeMenu)this.f_97732_).difficulty < i + 2 || this.game == null) continue;
            graphics.m_280218_(GUI, this.f_97735_ + 225, this.f_97736_ + 40 + 18 * i, 16, 240, 16, 16);
        }
    }

    public IMicroscopeGame getGame() {
        return this.game;
    }

    public void startGame() {
        this.clearGame();
        if (((MicroscopeMenu)this.f_97732_).possibleMutationsCount != ((MicroscopeMenu)this.f_97732_).researchedMutationsCount) {
            this.game = (IMicroscopeGame)this.m_142416_((GuiEventListener)new ConnectWiresGame(this.f_97735_ + 8, this.f_97736_ + 8, 215, 120, ((MicroscopeMenu)this.f_97732_).getDifficulty(), this));
            ((MicroscopeMenu)this.f_97732_).setState(MicroscopeGameClientbound.GameState.ONGOING);
        }
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        if (this.analyzeButton.m_274382_() && this.game != null) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.m_237113_((String)"Analyze material").m_130940_(ChatFormatting.GRAY));
            components.add(Component.m_237119_());
            ChatFormatting color = ((MicroscopeMenu)this.f_97732_).canSendHint() ? ChatFormatting.GRAY : ChatFormatting.RED;
            MutableComponent materialComponent = ((MicroscopeMenu)this.f_97732_).difficulty == 1 ? Component.m_237113_((String)"1 research material").m_130940_(color) : Component.m_237113_((String)(Math.min(((MicroscopeMenu)this.f_97732_).difficulty, 6) - 1 + " research materials")).m_130940_(color);
            components.add(materialComponent);
            pGuiGraphics.m_280666_(this.f_96547_, components, pX, pY);
        }
    }

    public void clearGame() {
        this.m_169411_((GuiEventListener)this.game);
        this.game = null;
    }

    private class AnalyzeButton
    extends ImageButton {
        private boolean clicked;

        public AnalyzeButton(int pX, int pY, int pWidth, int pHeight, int pXTexStart, int pYTexStart, ResourceLocation pResourceLocation, Button.OnPress pOnPress) {
            super(pX, pY, pWidth, pHeight, pXTexStart, pYTexStart, pResourceLocation, pOnPress);
            this.clicked = false;
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.m_280218_(this.f_94223_, this.m_252754_(), this.m_252907_(), this.clicked || !((MicroscopeMenu)MicroscopeScreen.this.f_97732_).canSendHint() || MicroscopeScreen.this.game == null ? 0 : (this.f_93622_ ? 32 : 16), 228, 16, 12);
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            boolean flag;
            if (this.f_93623_ && this.f_93624_ && this.m_7972_(pButton) && (flag = this.m_93680_(pMouseX, pMouseY)) && ((MicroscopeMenu)MicroscopeScreen.this.f_97732_).canSendHint() && MicroscopeScreen.this.game != null) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                this.m_5716_(pMouseX, pMouseY);
                return true;
            }
            return false;
        }
    }
}

