/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen.widget;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.accbdd.complicated_bees.screen.LibraryMenu;
import com.accbdd.complicated_bees.screen.LibraryScreen;
import com.accbdd.complicated_bees.screen.widget.LibraryInfoWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LibraryMutationWidget
extends AbstractScrollWidget {
    LibraryMenu menu;
    protected List<Mutation> possibleMutations = List.of();
    protected List<Mutation> researchedMutations = List.of();
    protected BreedingTracker tracker;
    protected LibraryInfoWidget infoWidget;
    public ItemStack hoveredStack = null;
    int mouseX = 0;
    int mouseY = 0;
    protected int selected;
    protected boolean selectedResearched;
    protected boolean selectedDiscovered;

    public LibraryMutationWidget(int pX, int pY, int pWidth, int pHeight, LibraryMenu menu) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.menu = menu;
        this.selected = -1;
        this.selectedResearched = false;
        this.selectedDiscovered = false;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.selected = this.getMutationIndexAt(pMouseX - (double)this.m_252754_(), pMouseY - (double)this.m_252907_());
        if (this.selected != -1) {
            this.selectedDiscovered = this.tracker.getDiscoveredMutations().contains(MutationRegistration.getResourceLocation(this.possibleMutations.get(this.selected)));
            this.selectedResearched = this.tracker.getResearchedMutations().contains(MutationRegistration.getResourceLocation(this.possibleMutations.get(this.selected)));
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private int getMutationIndexAt(double x, double y) {
        int indexClicked = (int)((y + this.m_239030_()) / 18.0);
        if (indexClicked >= 0 && 0.0 < x && x < 107.0 && indexClicked < this.possibleMutations.size()) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return indexClicked;
        }
        if (this.selected != -1) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
        }
        return -1;
    }

    protected int m_239019_() {
        return this.possibleMutations.size() * 18;
    }

    protected double m_239725_() {
        return 8.0;
    }

    protected void m_289749_(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight) {
    }

    protected void m_239516_(GuiGraphics pGuiGraphics) {
    }

    protected void m_239197_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (this.menu.getClientDirty()) {
            this.queryTracker();
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        this.hoveredStack = null;
        this.renderMutations(graphics, 2, 2);
        graphics.m_280168_().m_85849_();
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    private void renderMutations(GuiGraphics graphics, int pX, int pY) {
        for (int i = 0; i < this.possibleMutations.size(); ++i) {
            if (this.selected == i) {
                graphics.m_280509_(pX - 1, pY + 18 * i - 1, pX + this.m_5711_(), pY + 18 * (i + 1) - 1, -10066330);
                graphics.m_280218_(LibraryScreen.GUI, pX + 93, pY + 18 * i, 48, 240, 9, 16);
            }
            this.renderEquation(graphics, this.possibleMutations.get(i), pX, pY + 18 * i);
        }
    }

    private void renderEquation(GuiGraphics graphics, Mutation mutation, int pX, int pY) {
        boolean flag = this.tracker.getResearchedMutations().contains(MutationRegistration.getResourceLocation(mutation));
        this.drawSpecies(graphics, mutation.getFirstSpecies(), pX, pY, flag);
        this.drawPlus(graphics, pX + 16, pY);
        this.drawSpecies(graphics, mutation.getSecondSpecies(), pX + 32, pY, flag);
        this.drawEquals(graphics, pX + 48, pY);
        this.drawSpecies(graphics, mutation.getResultSpecies(), pX + 64, pY, flag);
    }

    private void drawQuestionMark(GuiGraphics graphics, int pX, int pY) {
        graphics.m_280218_(LibraryScreen.GUI, pX, pY, 0, 240, 16, 16);
    }

    private void drawPlus(GuiGraphics graphics, int pX, int pY) {
        graphics.m_280218_(LibraryScreen.GUI, pX, pY, 16, 240, 16, 16);
    }

    private void drawEquals(GuiGraphics graphics, int pX, int pY) {
        graphics.m_280218_(LibraryScreen.GUI, pX, pY, 32, 240, 16, 16);
    }

    private void drawSpecies(GuiGraphics graphics, Species species, int pX, int pY, boolean flag) {
        if (!this.tracker.getDiscoveredSpecies().contains(SpeciesRegistration.getResourceLocation(species)) && !flag) {
            this.drawQuestionMark(graphics, pX, pY);
        } else {
            ItemStack stack = species.toStack((Item)ItemsRegistration.DRONE.get());
            graphics.m_280480_(stack, pX, pY);
            if (this.mouseX >= pX + this.m_252754_() && this.mouseX <= pX + this.m_252754_() + 16 && (double)this.mouseY + this.m_239030_() >= (double)(pY + this.m_252907_()) && (double)this.mouseY + this.m_239030_() <= (double)(pY + this.m_252907_() + 16) && this.mouseY >= this.m_252907_() && this.mouseY <= this.m_252907_() + this.m_93694_()) {
                this.hoveredStack = stack;
            }
        }
    }

    private void queryTracker() {
        this.menu.setClientDirty(false);
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        this.tracker = BreedingTracker.getTracker(Minecraft.m_91087_().f_91074_.m_20148_());
        if (this.tracker == null) {
            return;
        }
        ItemStack bee = this.menu.m_38853_(0).m_7993_();
        if (bee.m_41619_()) {
            this.possibleMutations = List.of();
            this.researchedMutations = List.of();
            return;
        }
        ResourceLocation species = ResourceLocation.m_135820_((String)bee.m_41783_().m_128461_("species"));
        Registry mutationRegistry = (Registry)GeneticHelper.getRegistryAccess().m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get();
        List<Mutation> mutations = mutationRegistry.m_123024_().filter(mutation -> mutation.getFirst().equals((Object)species) || mutation.getSecond().equals((Object)species)).toList();
        List<Mutation> researched = this.tracker.getResearchedMutations().stream().filter(location -> {
            if (mutationRegistry.m_7745_(location) == null) {
                return false;
            }
            return ((Mutation)mutationRegistry.m_7745_(location)).getFirst().equals((Object)species) || ((Mutation)mutationRegistry.m_7745_(location)).getSecond().equals((Object)species);
        }).map(arg_0 -> ((Registry)mutationRegistry).m_7745_(arg_0)).toList();
        this.possibleMutations = mutations;
        this.researchedMutations = researched;
    }
}

