/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen.widget.microscope;

import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameClientbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameServerbound;
import com.accbdd.complicated_bees.screen.MicroscopeScreen;
import com.accbdd.complicated_bees.screen.widget.microscope.AbstractMicroscopeGame;
import com.accbdd.complicated_bees.util.GuiHelper;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ConnectWiresGame
extends AbstractMicroscopeGame {
    private static final ResourceLocation BG = new ResourceLocation("complicated_bees", "textures/gui/microscope/matching.png");
    private static final int BORDER_WIDTH = 1;
    private static final int VERTICAL_PADDING = 3;
    private static final int VERTICAL_SPACE = 29;
    private static final int MIN_SECTION_HEIGHT = 15;
    private static final int MIN_SECTION_WIDTH = 15;
    byte[] currentGuess;
    Section[] sections;
    List<Section> hintHighlighted = new ArrayList<Section>();
    byte lastClicked = (byte)-1;
    byte clickedSquare = (byte)-1;
    int maxSectionWidth;
    int sectionPairs;
    Component bannerText;
    MicroscopeGameClientbound.GameState gameState;
    Random rand = new Random();
    private static final int BG_ANIM_LENGTH = 40;
    private static final int SQUARE_ANIM_LENGTH = 60;
    private float transparencyMod = 0.0f;
    private float animationTimer = 100.0f;

    public ConnectWiresGame(int pX, int pY, int width, int height, int difficulty, MicroscopeScreen screen) {
        super(pX, pY, width, height, difficulty, screen);
        this.sectionPairs = this.getDifficulty();
        this.currentGuess = new byte[this.sectionPairs];
        this.reset();
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.animationTimer > 0.0f) {
            this.animationTimer -= pPartialTick;
        }
        pGuiGraphics.m_280218_(BG, this.m_252754_(), this.m_252907_(), 0, 0, this.animationTimer > 60.0f ? (int)((float)this.m_5711_() - (this.animationTimer - 60.0f) * (float)this.m_5711_() / 40.0f) : this.m_5711_(), this.m_93694_());
        this.drawAllSections(pGuiGraphics, this.m_252754_(), this.m_252907_());
        this.drawAllLinks(pGuiGraphics);
        if (this.gameState != MicroscopeGameClientbound.GameState.ONGOING) {
            this.transparencyMod += pPartialTick;
            this.transparencyMod %= 30.0f;
            this.drawText(pGuiGraphics);
        }
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    @Override
    public void hint(byte index, byte hint) {
        this.hintHighlighted.clear();
        this.hintHighlighted.add(this.sections[index]);
        this.hintHighlighted.add(this.sections[this.sectionPairs + hint]);
    }

    private void drawText(GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        int color = this.gameState == MicroscopeGameClientbound.GameState.FAILED ? -65536 : -16711936;
        int n = this.m_93694_() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        graphics.m_280509_(0, n - 9 / 2 - 14, this.m_5711_(), this.m_93694_() / 2 + 16, color & (this.transparencyMod < 15.0f ? -858993664 : -1429419008));
        graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        int n2 = this.m_5711_() / 4;
        int n3 = this.m_93694_() / 4;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        graphics.m_280653_(font, this.bannerText, n2, n3 - 9 / 2 - 3, color);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        Font font2 = Minecraft.m_91087_().f_91062_;
        MutableComponent mutableComponent = Component.m_237115_((String)"gui.complicated_bees.microscope.click");
        int n4 = this.m_5711_() / 2;
        int n5 = this.m_93694_() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        graphics.m_280653_(font2, (Component)mutableComponent, n4, n5 - 9 / 2 + 9, color);
        graphics.m_280168_().m_85849_();
    }

    private void drawAllSections(GuiGraphics graphics, int pX, int pY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        if (this.animationTimer <= 60.0f) {
            for (int i = 0; i < this.sections.length; ++i) {
                Section section = this.sections[i];
                if (!((float)((this.sections.length - i) * (60 / this.sections.length)) >= this.animationTimer)) continue;
                GuiHelper.drawBorderedRectangle(graphics, section.x, section.y, section.width, section.height, 1, this.hintHighlighted.contains(section) ? -16711681 : -13312, this.lastClicked == i ? 1728039936 : section.color);
            }
        }
        graphics.m_280168_().m_85849_();
    }

    private void drawAllLinks(GuiGraphics graphics) {
        for (int i = 0; i < this.currentGuess.length; ++i) {
            if (this.currentGuess[i] == -1) continue;
            Section start = this.sections[i];
            Section end = this.sections[this.currentGuess[i] + this.sectionPairs];
            this.drawLineBetween(graphics, start.getCenter()[0] + this.m_252754_(), start.getCenter()[1] + this.m_252907_(), end.getCenter()[0] + this.m_252754_(), end.getCenter()[1] + this.m_252907_());
        }
    }

    private void drawLineBetween(GuiGraphics graphics, int x, int y, int x2, int y2) {
        int dist = (int)Math.sqrt(Math.pow(x2 - x, 2.0) + Math.pow(y2 - y, 2.0));
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_272245_(Axis.f_252403_.m_252977_((float)(Math.atan2(x2 - x, y2 - y) * -180.0 / Math.PI)), (float)x, (float)y, 0.0f);
        graphics.m_280509_(x - 1, y - 1, x + 1, y + dist + 1, -1);
        graphics.m_280168_().m_85849_();
    }

    private void generateSections() {
        this.sections = new Section[this.sectionPairs * 2];
        this.maxSectionWidth = this.m_5711_() / this.sectionPairs;
        for (int i = 0; i < this.sections.length; ++i) {
            int minX = i % this.sectionPairs * this.maxSectionWidth;
            int x = this.rand.nextInt(minX, minX + this.maxSectionWidth - 15);
            int minY = i < this.sectionPairs ? 3 : this.m_93694_() - 3 - 29;
            int y = this.rand.nextInt(minY, minY + 29 - 15);
            this.sections[i] = new Section(x, y, this.rand.nextInt(15, this.maxSectionWidth - (x - minX)), this.rand.nextInt(15, 29 - (y - minY)), 0);
        }
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        super.m_5716_(pMouseX, pMouseY);
        this.clickedSquare = this.getSquare(pMouseX, pMouseY);
        if (this.animationTimer > 0.0f) {
            this.animationTimer = 0.0f;
            return;
        }
        if (this.clickedSquare == -1 || this.gameState != MicroscopeGameClientbound.GameState.ONGOING) {
            this.lastClicked = (byte)-1;
            if (this.gameState == MicroscopeGameClientbound.GameState.FAILED || this.gameState == MicroscopeGameClientbound.GameState.WON) {
                this.reset();
            }
            return;
        }
        this.hintHighlighted.clear();
        if (this.lastClicked != -1) {
            if (this.lastClicked < this.sectionPairs && this.clickedSquare >= this.sectionPairs) {
                this.currentGuess[this.lastClicked] = (byte)(this.clickedSquare - this.sectionPairs);
                this.sendGuess(this.currentGuess);
            } else if (this.clickedSquare < this.sectionPairs && this.lastClicked >= this.sectionPairs) {
                this.currentGuess[this.clickedSquare] = (byte)(this.lastClicked - this.sectionPairs);
                this.sendGuess(this.currentGuess);
            } else {
                this.lastClicked = this.clickedSquare;
            }
        } else {
            this.lastClicked = this.clickedSquare;
        }
    }

    private byte getSquare(double pX, double pY) {
        for (byte i = 0; i < this.sections.length; i = (byte)(i + 1)) {
            if (!this.sections[i].checkInside(pX - (double)this.m_252754_(), pY - (double)this.m_252907_())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sendGuess(byte[] guess) {
        PacketHandler.CHANNEL.sendToServer((Object)new MicroscopeGameServerbound(guess));
    }

    @Override
    public void setGameState(MicroscopeGameClientbound.GameState state) {
        this.gameState = state;
        switch (state) {
            case START: {
                this.reset();
                break;
            }
            case FAILED: {
                this.lastClicked = (byte)-1;
                for (int i = 0; i < this.sections.length; i = (int)((byte)(i + 1))) {
                    this.sections[i].color = 0x66FF0000;
                }
                this.bannerText = Component.m_237115_((String)"gui.complicated_bees.microscope.sequence.lose");
                break;
            }
            case WON: 
            case ONGOING: {
                this.sections[this.lastClicked].color = 0x6600FF00;
                this.sections[this.clickedSquare].color = 0x6600FF00;
                this.bannerText = Component.m_237115_((String)"gui.complicated_bees.microscope.sequence.win");
                this.lastClicked = (byte)-1;
            }
        }
    }

    @Override
    public void reset() {
        this.getScreen().clearGame();
        this.animationTimer = 100.0f;
        this.maxSectionWidth = this.f_93618_ / this.sectionPairs;
        Arrays.fill(this.currentGuess, (byte)-1);
        this.sendGuess(this.currentGuess);
        this.gameState = MicroscopeGameClientbound.GameState.ONGOING;
        this.generateSections();
    }

    private static final class Section {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private int color;

        private Section(int x, int y, int width, int height, int color) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.color = color;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public boolean checkInside(double pX, double pY) {
            return (double)this.x < pX && pX < (double)(this.x + this.width) && (double)this.y < pY && pY < (double)(this.y + this.height);
        }

        public int[] getCenter() {
            return new int[]{this.x + this.width / 2, this.y + this.height / 2};
        }
    }
}

