/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.util;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;

public class BlockPosSpiralIterator
extends AbstractIterator<BlockPos> {
    private final BlockPos center;
    private final int hRadius;
    private final int vRadius;
    private int shellIndex;
    private int currentShell;
    private List<BlockPos> currentShellPoints;

    public BlockPosSpiralIterator(BlockPos center, int hRadius, int vRadius) {
        this.center = center;
        this.hRadius = hRadius;
        this.vRadius = vRadius;
        this.currentShellPoints = this.generateShellPoints(this.currentShell);
    }

    @Nullable
    protected BlockPos computeNext() {
        while (this.currentShell <= this.hRadius && this.currentShell <= this.vRadius) {
            BlockPos current = this.nextPos();
            if (current.m_123342_() < this.center.m_123342_() - this.vRadius || current.m_123342_() > this.center.m_123342_() + this.vRadius || current.m_123341_() < this.center.m_123341_() - this.hRadius || current.m_123341_() > this.center.m_123341_() + this.hRadius || current.m_123343_() < this.center.m_123343_() - this.hRadius || current.m_123343_() > this.center.m_123343_() + this.hRadius) continue;
            return current;
        }
        return (BlockPos)this.endOfData();
    }

    protected BlockPos nextPos() {
        BlockPos offset = this.currentShellPoints.get(this.shellIndex++);
        if (this.shellIndex >= this.currentShellPoints.size()) {
            ++this.currentShell;
            this.shellIndex = 0;
            if (this.currentShell <= this.hRadius || this.currentShell <= this.vRadius) {
                this.currentShellPoints = this.generateShellPoints(this.currentShell);
            }
        }
        return this.center.m_121955_((Vec3i)offset);
    }

    private List<BlockPos> generateShellPoints(int shellRadius) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        if (shellRadius == 0) {
            points.add(new BlockPos(0, 0, 0));
            return points;
        }
        for (int x = -shellRadius; x <= shellRadius; ++x) {
            for (int y = -shellRadius; y <= shellRadius; ++y) {
                for (int z = -shellRadius; z <= shellRadius; ++z) {
                    if (Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z))) != shellRadius) continue;
                    points.add(new BlockPos(x, y, z));
                }
            }
        }
        return points;
    }
}

