/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.worldgen;

import com.accbdd.complicated_bees.block.BeeNestBlock;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class ComplicatedBeenestDecorator
extends TreeDecorator {
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
    private final float probability;
    private final String speciesKey;
    public static final Codec<ComplicatedBeenestDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(ComplicatedBeenestDecorator::getProbability), (App)Codec.STRING.fieldOf("species").forGetter(ComplicatedBeenestDecorator::getSpeciesKey)).apply((Applicative)instance, ComplicatedBeenestDecorator::new));

    public ComplicatedBeenestDecorator(float probability, String speciesKey) {
        this.probability = probability;
        this.speciesKey = speciesKey;
    }

    public float getProbability() {
        return this.probability;
    }

    public String getSpeciesKey() {
        return this.speciesKey;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return EsotericRegistration.COMPLICATED_BEENEST_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource rand = context.m_226067_();
        if (!(rand.m_188501_() >= this.probability)) {
            ObjectArrayList leaves = context.m_226069_();
            ObjectArrayList logs = context.m_226068_();
            int i = !leaves.isEmpty() ? Math.max(((BlockPos)leaves.get(0)).m_123342_() - 1, ((BlockPos)logs.get(0)).m_123342_() + 1) : Math.min(((BlockPos)logs.get(0)).m_123342_() + 1 + rand.m_188503_(3), ((BlockPos)logs.get(logs.size() - 1)).m_123342_());
            List list2 = logs.stream().filter(pos -> pos.m_123342_() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0))).collect(Collectors.toList());
            if (!list2.isEmpty()) {
                Collections.shuffle(list2);
                Optional<BlockPos> optional = list2.stream().filter(arg_0 -> ((TreeDecorator.Context)context).m_226059_(arg_0)).findFirst();
                if (optional.isPresent()) {
                    context.m_226061_(optional.get(), ((BeeNestBlock)((Object)BlocksRegistration.BEE_NEST.get())).m_49966_());
                    context.m_226058_().m_141902_(optional.get(), BlockEntitiesRegistration.BEE_NEST_ENTITY.get()).ifPresent(be -> be.setSpecies(SpeciesRegistration.getFromResourceLocation(ResourceLocation.m_135820_((String)this.speciesKey))));
                }
            }
        }
    }
}

