/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees;

import com.accbdd.complicated_bees.bees.Comb;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.effect.IBeeEffect;
import com.accbdd.complicated_bees.bees.gene.IGene;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.block.BeeNestBlock;
import com.accbdd.complicated_bees.block.entity.renderer.MicroscopeBlockEntityRenderer;
import com.accbdd.complicated_bees.client.BeeModel;
import com.accbdd.complicated_bees.client.ColorHandlers;
import com.accbdd.complicated_bees.client.OptimizedBeeModelLoader;
import com.accbdd.complicated_bees.command.ModCommands;
import com.accbdd.complicated_bees.config.CommonConfig;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.datagen.DataGenerators;
import com.accbdd.complicated_bees.datagen.condition.ItemEnabledCondition;
import com.accbdd.complicated_bees.event.ComplicatedBeesEvents;
import com.accbdd.complicated_bees.item.CombItem;
import com.accbdd.complicated_bees.item.DroneItem;
import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.TrackerSyncClientbound;
import com.accbdd.complicated_bees.particle.BeeParticle;
import com.accbdd.complicated_bees.registry.BeeEffectRegistration;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.CombRegistration;
import com.accbdd.complicated_bees.registry.EntitiesRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.GeneRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MenuRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.accbdd.complicated_bees.screen.AnalyzerScreen;
import com.accbdd.complicated_bees.screen.ApiaryScreen;
import com.accbdd.complicated_bees.screen.BeeSorterScreen;
import com.accbdd.complicated_bees.screen.CentrifugeScreen;
import com.accbdd.complicated_bees.screen.FurnaceGeneratorScreen;
import com.accbdd.complicated_bees.screen.GyrofugeScreen;
import com.accbdd.complicated_bees.screen.HoneyGeneratorScreen;
import com.accbdd.complicated_bees.screen.LibraryScreen;
import com.accbdd.complicated_bees.screen.MellariumFrameHousingScreen;
import com.accbdd.complicated_bees.screen.MellariumHydroregulatorScreen;
import com.accbdd.complicated_bees.screen.MellariumMutatorScreen;
import com.accbdd.complicated_bees.screen.MellariumScreen;
import com.accbdd.complicated_bees.screen.MellariumTempUnitScreen;
import com.accbdd.complicated_bees.screen.MicroscopeScreen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="complicated_bees")
public class ComplicatedBees {
    public static final String MODID = "complicated_bees";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"complicated_bees");
    public static Supplier<IForgeRegistry<IGene<?>>> GENE_REGISTRY;
    public static Supplier<IForgeRegistry<IBeeEffect>> BEE_EFFECT_REGISTRY;
    public static Supplier<IForgeRegistry<IMutationCondition>> MUTATION_CONDITION_REGISTRY;
    public static final RegistryObject<CreativeModeTab> BEES_TAB;

    public ComplicatedBees(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::registerSerializers);
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(this::registerDatapackRegistries);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(DataGenerators::generate);
        if (FMLLoader.getDist().isClient()) {
            modEventBus.addListener(ColorHandlers::registerItemColorHandlers);
            modEventBus.addListener(ColorHandlers::registerBlockColorHandlers);
        }
        BlocksRegistration.BLOCKS.register(modEventBus);
        ItemsRegistration.ITEMS.register(modEventBus);
        BlockEntitiesRegistration.BLOCK_ENTITIES.register(modEventBus);
        MenuRegistration.MENU_TYPES.register(modEventBus);
        GeneRegistration.GENES.register(modEventBus);
        BeeEffectRegistration.EFFECTS.register(modEventBus);
        MutationRegistration.MUTATION_CONDITIONS.register(modEventBus);
        EntitiesRegistration.ENTITY_TYPE.register(modEventBus);
        EsotericRegistration.LOOT_ITEM_FUNCTION_REGISTER.register(modEventBus);
        EsotericRegistration.TREE_DECORATOR_REGISTER.register(modEventBus);
        EsotericRegistration.FEATURE_REGISTER.register(modEventBus);
        EsotericRegistration.RECIPE_TYPE_REGISTER.register(modEventBus);
        EsotericRegistration.RECIPE_SERIALIZER_REGISTER.register(modEventBus);
        EsotericRegistration.PARTICLE_TYPE.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(ComplicatedBeesEvents::onItemPickup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.CONFIG_SPEC);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.CONFIG_SPEC);
        CREATIVE_MODE_TABS.register(modEventBus);
    }

    @SubscribeEvent
    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(SpeciesRegistration.SPECIES_REGISTRY_KEY, Species.SPECIES_CODEC, Species.SPECIES_CODEC);
        event.dataPackRegistry(CombRegistration.COMB_REGISTRY_KEY, Comb.CODEC, Comb.CODEC);
        event.dataPackRegistry(MutationRegistration.MUTATION_REGISTRY_KEY, Mutation.MUTATION_CODEC, Mutation.MUTATION_CODEC);
        event.dataPackRegistry(FlowerRegistration.FLOWER_REGISTRY_KEY, FlowerRegistration.CODEC, FlowerRegistration.CODEC);
    }

    @SubscribeEvent
    public void registerRegistries(NewRegistryEvent event) {
        GENE_REGISTRY = event.create(GeneRegistration.GENE_REGISTRY);
        BEE_EFFECT_REGISTRY = event.create(BeeEffectRegistration.BEE_EFFECT_REGISTRY);
        MUTATION_CONDITION_REGISTRY = event.create(MutationRegistration.MUTATION_CONDITION_REGISTRY);
    }

    @SubscribeEvent
    public void registerSerializers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((IConditionSerializer)ItemEnabledCondition.Serializer.INSTANCE));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) {
        LOGGER.info("Registered {} species", (Object)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_13562_());
        LOGGER.info("Registered {} combs", (Object)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(CombRegistration.COMB_REGISTRY_KEY).get()).m_13562_());
        LOGGER.info("Registered {} mutations", (Object)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get()).m_13562_());
        LOGGER.info("Registered {} flowers", (Object)((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).get()).m_13562_());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("syncing tracker to {}", (Object)event.getEntity().m_7755_());
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(event.getEntity().m_20148_())), (Object)new TrackerSyncClientbound(BreedingTracker.getTracker(event.getEntity())));
    }

    static {
        BEES_TAB = CREATIVE_MODE_TABS.register(MODID, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.complicated_bees")).m_257737_(() -> ((DroneItem)((Object)((Object)((Object)ItemsRegistration.DRONE.get())))).m_7968_()).m_257501_((parameters, output) -> {
            for (RegistryObject<? extends Item> item : ItemsRegistration.CREATIVE_TAB_ITEMS) {
                output.m_246326_((ItemLike)((Item)item.get()));
            }
            RegistryAccess access = GeneticHelper.getRegistryAccess();
            if (access != null) {
                Set speciesSet = ((Registry)access.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_6579_();
                for (Map.Entry entry : speciesSet) {
                    if (((Species)entry.getValue()).getColor() == -1) continue;
                    output.m_246601_(((Species)entry.getValue()).toMembers());
                }
                for (ResourceLocation id : ((Registry)access.m_6632_(CombRegistration.COMB_REGISTRY_KEY).get()).m_6566_()) {
                    output.m_246342_(CombItem.setComb(((CombItem)((Object)((Object)((Object)ItemsRegistration.COMB.get())))).m_7968_(), id));
                }
                for (Map.Entry entry : speciesSet) {
                    output.m_246342_(BeeNestBlock.stackNest(((Item)ItemsRegistration.BEE_NEST.get()).m_7968_(), (Species)entry.getValue()));
                }
            }
        }).m_257652_());
    }

    @Mod.EventBusSubscriber(modid="complicated_bees", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_(EntitiesRegistration.BEE_STAFF_MOUNT.get(), context -> new ThrownItemRenderer(context, 1.0f, true));
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)BlocksRegistration.HONEYED_WOOD);
                WoodType.m_61844_((WoodType)BlocksRegistration.HONEYED_WOOD);
                MenuScreens.m_96206_(MenuRegistration.CENTRIFUGE_MENU.get(), CentrifugeScreen::new);
                MenuScreens.m_96206_(MenuRegistration.APIARY_MENU.get(), ApiaryScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_MENU.get(), MellariumScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_FRAME_MENUS.get(0).get(), MellariumFrameHousingScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_FRAME_MENUS.get(1).get(), MellariumFrameHousingScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_FRAME_MENUS.get(2).get(), MellariumFrameHousingScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_TEMP_UNIT_MENU.get(), MellariumTempUnitScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_MUTATOR_MENU.get(), MellariumMutatorScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MELLARIUM_HYDROREGULATOR_MENU.get(), MellariumHydroregulatorScreen::new);
                MenuScreens.m_96206_(MenuRegistration.FURNACE_GENERATOR_MENU.get(), FurnaceGeneratorScreen::new);
                MenuScreens.m_96206_(MenuRegistration.HONEY_GENERATOR_MENU.get(), HoneyGeneratorScreen::new);
                MenuScreens.m_96206_(MenuRegistration.ANALYZER_MENU.get(), AnalyzerScreen::new);
                MenuScreens.m_96206_(MenuRegistration.MICROSCOPE_MENU.get(), MicroscopeScreen::new);
                MenuScreens.m_96206_(MenuRegistration.LIBRARY_MENU.get(), LibraryScreen::new);
                MenuScreens.m_96206_(MenuRegistration.BEE_SORTER_MENU.get(), BeeSorterScreen::new);
                MenuScreens.m_96206_(MenuRegistration.GYROFUGE_MENU.get(), GyrofugeScreen::new);
                MenuScreens.m_96206_(MenuRegistration.AUTOLYZER_MENU.get(), AnalyzerScreen::new);
            });
        }

        @SubscribeEvent
        public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(OptimizedBeeModelLoader.ID.m_135815_(), (IGeometryLoader)new OptimizedBeeModelLoader());
            event.register(BeeModel.Loader.ID.m_135815_(), (IGeometryLoader)new BeeModel.Loader());
        }

        @SubscribeEvent
        public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            try {
                for (Map.Entry entry : manager.m_214159_("models/bee", res -> res.m_135815_().endsWith(".json")).entrySet()) {
                    String path = ((ResourceLocation)entry.getKey()).m_135815_();
                    String modelPath = path.substring("models/".length(), path.length() - ".json".length());
                    event.register(ResourceLocation.m_214293_((String)((ResourceLocation)entry.getKey()).m_135827_(), (String)modelPath));
                    LOGGER.debug("Loaded bee model: " + String.valueOf(entry.getKey()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to read bee models: " + String.valueOf(e));
            }
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)EsotericRegistration.BEE_PARTICLE.get(), BeeParticle.Provider::new);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(BlockEntitiesRegistration.MICROSCOPE_BLOCK_ENTITY.get(), MicroscopeBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(BlockEntitiesRegistration.CB_SIGN_ENTITY.get(), SignRenderer::new);
            event.registerBlockEntityRenderer(BlockEntitiesRegistration.CB_HANGING_SIGN_ENTITY.get(), HangingSignRenderer::new);
        }
    }
}

