/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Chromosome;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Genome;
import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.bees.gene.Gene;
import com.accbdd.complicated_bees.bees.gene.GeneSpecies;
import com.accbdd.complicated_bees.bees.gene.IGene;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.util.ComplicatedBeesCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Species {
    private final int color;
    private final int nest_color;
    private List<ResourceLocation> models;
    private final List<Product> products;
    private final List<Product> specialty_products;
    private final Chromosome default_chromosome;
    private final boolean dominant;
    private final boolean foil;
    public ResourceLocation builderOverride;
    public static List<ResourceLocation> DEFAULT_MODELS = new ArrayList<ResourceLocation>(){
        {
            this.add(new ResourceLocation("complicated_bees", "bee/base_drone"));
            this.add(new ResourceLocation("complicated_bees", "bee/base_princess"));
            this.add(new ResourceLocation("complicated_bees", "bee/base_queen"));
        }
    };
    public static final Species INVALID = new Species();
    public static final Codec<Species> SPECIES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("dominant", (Object)true).forGetter(Species::isDominant), (App)Codec.BOOL.optionalFieldOf("foil", (Object)false).forGetter(Species::isFoil), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("models", DEFAULT_MODELS).forGetter(Species::getModels), (App)ComplicatedBeesCodecs.HEX_STRING.optionalFieldOf("color", (Object)-1).forGetter(Species::getColor), (App)ComplicatedBeesCodecs.HEX_STRING.optionalFieldOf("nest_color", (Object)-1).forGetter(Species::getNestColor), (App)Product.CODEC.listOf().optionalFieldOf("products", new ArrayList()).forGetter(Species::getProducts), (App)Product.CODEC.listOf().optionalFieldOf("specialty_products", new ArrayList()).forGetter(Species::getSpecialtyProducts), (App)CompoundTag.f_128325_.optionalFieldOf("default_chromosome", (Object)new Chromosome().serialize()).forGetter(species -> species.getDefaultChromosome().serialize())).apply((Applicative)instance, Species::new));

    public Species() {
        this(false, false, new ArrayList<ResourceLocation>(), 0xFFFFFF, 0xFFFFFF, new ArrayList<Product>(), new ArrayList<Product>(), new Chromosome());
        this.models = DEFAULT_MODELS;
    }

    public Species(boolean dominant, boolean foil, List<ResourceLocation> models, int color, int nest_color, List<Product> products, List<Product> specialtyProducts, Chromosome default_chromosome) {
        this.dominant = dominant;
        this.foil = foil;
        this.models = models;
        this.color = color;
        this.nest_color = nest_color;
        this.products = products;
        this.specialty_products = specialtyProducts;
        this.default_chromosome = default_chromosome.setGene(GeneSpecies.ID, new GeneSpecies(this, dominant));
    }

    public Species(boolean dominant, boolean foil, List<ResourceLocation> models, int color, int nest_color, List<Product> products, List<Product> specialtyProducts, CompoundTag defaultGenomeAsTag) {
        this(dominant, foil, models, color, nest_color, products, specialtyProducts, new Chromosome(defaultGenomeAsTag));
        this.default_chromosome.setGene(GeneSpecies.ID, new GeneSpecies(this, dominant));
    }

    public boolean isFoil() {
        return this.foil;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public List<ResourceLocation> getModels() {
        return this.models;
    }

    public int getColor() {
        return this.color;
    }

    public int getNestColor() {
        return this.nest_color == -1 ? this.color : this.nest_color;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public List<Product> getSpecialtyProducts() {
        return this.specialty_products;
    }

    public Chromosome getDefaultChromosome() {
        return this.default_chromosome.copy();
    }

    public ItemStack toStack(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41784_().m_128379_("analyzed", true);
        return GeneticHelper.setGenome(stack, new Genome(this.getDefaultChromosome(), this.getDefaultChromosome()));
    }

    public List<ItemStack> toMembers() {
        ArrayList<ItemStack> members = new ArrayList<ItemStack>();
        members.add(this.toStack((Item)ItemsRegistration.QUEEN.get()));
        members.add(this.toStack((Item)ItemsRegistration.PRINCESS.get()));
        members.add(this.toStack((Item)ItemsRegistration.DRONE.get()));
        return members;
    }

    public static class Builder {
        private boolean dominant = true;
        private boolean foil = false;
        private List<ResourceLocation> models = DEFAULT_MODELS;
        private int color = -1;
        private int nest_color = -1;
        private List<Product> products = new ArrayList<Product>();
        private List<Product> specialty_products = new ArrayList<Product>();
        private CompoundTag default_chromosome = new CompoundTag();
        private final ResourceLocation builderOverride;

        public static Builder of(Species copied, ResourceLocation builderOverride) {
            Builder builder = new Builder(builderOverride);
            builder.dominant = copied.dominant;
            builder.foil = copied.foil;
            builder.models = copied.models;
            builder.color = copied.color;
            builder.nest_color = copied.nest_color;
            builder.products = copied.products;
            builder.specialty_products = copied.specialty_products;
            builder.default_chromosome = copied.default_chromosome.serialize();
            return builder;
        }

        public Builder(ResourceLocation builderOverride) {
            this.builderOverride = builderOverride;
        }

        public Species build() {
            Species species = new Species(this.dominant, this.foil, this.models, this.color, this.nest_color, this.products, this.specialty_products, this.default_chromosome);
            species.builderOverride = this.builderOverride;
            return species;
        }

        public Builder dominant(boolean value) {
            this.dominant = value;
            return this;
        }

        public Builder foil(boolean value) {
            this.foil = value;
            return this;
        }

        public Builder models(List<ResourceLocation> models) {
            if (models.size() != 3) {
                throw new IllegalArgumentException("models should be a list of size 3");
            }
            this.models = models;
            return this;
        }

        public Builder colors(int color, int nest_color) {
            this.color = color;
            this.nest_color = nest_color;
            return this;
        }

        public Builder colors(int color) {
            this.color = color;
            this.nest_color = color;
            return this;
        }

        public Builder products(List<Product> products) {
            this.products = products;
            return this;
        }

        public Builder specialtyProducts(List<Product> specialty_products) {
            this.specialty_products = specialty_products;
            return this;
        }

        public Builder defaultChromosome(Chromosome chromosome) {
            this.default_chromosome = chromosome.serialize();
            return this;
        }

        public <T extends Gene<?>> Builder gene(Supplier<T> gene, T geneValue) {
            this.default_chromosome.m_128365_(ComplicatedBees.GENE_REGISTRY.get().getKey((Object)((IGene)gene.get())).toString(), (Tag)geneValue.serialize());
            return this;
        }
    }
}

