/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.gene.enums;

import com.accbdd.complicated_bees.ComplicatedBees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public enum EnumTemperature {
    FROZEN("frozen"),
    ICY("icy"),
    COLD("cold"),
    NORMAL("normal"),
    WARM("warm"),
    HOT("hot"),
    HELLISH("hellish");

    public final String name;

    private EnumTemperature(String name) {
        this.name = name;
    }

    public static EnumTemperature getFromValue(float temp) {
        if (temp > 1.0f) {
            return HOT;
        }
        if (temp > 0.85f) {
            return WARM;
        }
        if (temp > 0.35f) {
            return NORMAL;
        }
        if (temp > 0.0f) {
            return COLD;
        }
        if (temp > -0.35f) {
            return ICY;
        }
        return FROZEN;
    }

    public static EnumTemperature getFromBiome(Holder<Biome> biome) {
        return biome.m_203656_(BiomeTags.f_207612_) ? HELLISH : EnumTemperature.getFromValue(((Biome)biome.m_203334_()).m_47554_());
    }

    public static EnumTemperature getFromPosition(Level level, BlockPos pos) {
        return EnumTemperature.getFromBiome((Holder<Biome>)level.m_204166_(pos));
    }

    public static EnumTemperature getFromString(String str) {
        return switch (str.toLowerCase()) {
            case "hellish" -> HELLISH;
            case "hot" -> HOT;
            case "warm" -> WARM;
            case "normal" -> NORMAL;
            case "cold" -> COLD;
            case "icy" -> ICY;
            case "frozen" -> FROZEN;
            default -> {
                ComplicatedBees.LOGGER.warn("tried to convert unknown string {} to temperature; returning normal", (Object)str);
                yield NORMAL;
            }
        };
    }

    public String toString() {
        return this.name;
    }

    public MutableComponent getTranslationKey() {
        return Component.m_237115_((String)("gene.complicated_bees.temperature." + this.toString()));
    }
}

