/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutolyzerBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    public static final int SLOT_COUNT = 2;
    public static final int SLOT = 0;
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items){

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1 && AutolyzerBlockEntity.this.isBeeAnalyzed(this.getStackInSlot(1))) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }
    });

    public AutolyzerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.AUTOLYZER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(pTag.m_128469_(ITEMS_TAG));
        }
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemStack bee = this.getStackInSlot(1);
                if (!(this.getStackInSlot(0).m_41619_() || bee.m_41619_() || AutolyzerBlockEntity.this.isBeeAnalyzed(bee))) {
                    bee.m_41784_().m_128379_("analyzed", true);
                    this.getStackInSlot(0).m_41774_(1);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_204117_(ItemTagGenerator.ANALYZER_FUEL);
                }
                if (slot == 1) {
                    return stack.m_204117_(ItemTagGenerator.BEE);
                }
                return true;
            }
        };
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public boolean isBeeAnalyzed(ItemStack bee) {
        return bee.m_204117_(ItemTagGenerator.BEE) && bee.m_41784_().m_128471_("analyzed");
    }
}

