/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.gene.GeneSpecies;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.screen.widget.BeeTypeWidget;
import com.accbdd.complicated_bees.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeSorterBlockEntity
extends BlockEntity {
    public static final String TYPES = "types";
    public static final int TRANSFER_TICKS = 5;
    private byte[] typeFilters = new byte[6];
    private String[] speciesFilters;
    private final ItemStackHandler item = new ItemStackHandler(1);
    private final List<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
    private int transferCooldown;

    public BeeSorterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.BEE_SORTER_BLOCK_ENTITY.get(), pPos, pBlockState);
        for (int i = 0; i < this.typeFilters.length; ++i) {
            this.handlers.add(this.createFilterHandler(i));
        }
        this.speciesFilters = new String[36];
        this.transferCooldown = 5;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return side == null ? this.handlers.get(0).cast() : this.handlers.get(side.ordinal()).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128382_(TYPES, this.typeFilters);
        pTag.m_128365_("item", (Tag)this.item.serializeNBT());
        CompoundTag filterTag = new CompoundTag();
        for (int i = 0; i < 36; ++i) {
            if (this.speciesFilters[i] == null) continue;
            filterTag.m_128359_(String.valueOf(i), this.speciesFilters[i]);
        }
        pTag.m_128365_("filters", (Tag)filterTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_(TYPES) && pTag.m_128463_(TYPES).length == 6) {
            this.typeFilters = pTag.m_128463_(TYPES);
        }
        if (pTag.m_128441_("item")) {
            this.item.deserializeNBT(pTag.m_128469_("item"));
        }
        if (pTag.m_128441_("filters")) {
            CompoundTag filterTag = pTag.m_128469_("filters");
            for (String key : filterTag.m_128431_()) {
                try {
                    this.speciesFilters[Integer.parseInt((String)key)] = filterTag.m_128461_(key);
                }
                catch (NumberFormatException e) {
                    ComplicatedBees.LOGGER.error("tried to load bee sorter with illegal filter key at position {}", (Object)this.m_58899_());
                    break;
                }
            }
        }
    }

    public void serverTick() {
        if (!this.item.getStackInSlot(0).m_41619_() & (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)) {
            --this.transferCooldown;
        }
        if (this.transferCooldown <= 0) {
            this.transferCooldown = 5;
            int maxSpecificity = 1;
            ArrayList<Direction> possibleDirections = new ArrayList<Direction>();
            for (Direction direction : Direction.values()) {
                if (!(this.typeFilters[direction.ordinal()] != BeeTypeWidget.BeeTypeState.NONE.ordinal() & this.m_58904_() != null)) continue;
                int curSpecificity = this.filterSpecificity(direction);
                if (curSpecificity > maxSpecificity) {
                    maxSpecificity = curSpecificity;
                    possibleDirections.clear();
                }
                if (!(this.canInsertItem(direction) & curSpecificity >= maxSpecificity)) continue;
                possibleDirections.add(direction);
            }
            if (!possibleDirections.isEmpty()) {
                Direction dir = (Direction)possibleDirections.get(this.m_58904_().m_213780_().m_188503_(possibleDirections.size()));
                Util.moveInventoryItems((IItemHandler)this.item, this.getHandler(dir).get());
            }
        }
    }

    private boolean canInsertItem(Direction dir) {
        ItemStack extracted;
        boolean flag = false;
        Optional<IItemHandler> dest = this.getHandler(dir);
        if (dest.isPresent() && !(extracted = this.item.extractItem(0, 1, true)).m_41619_()) {
            flag = ItemHandlerHelper.insertItem((IItemHandler)dest.get(), (ItemStack)extracted, (boolean)true).m_41619_();
        }
        return flag;
    }

    private Optional<IItemHandler> getHandler(Direction dir) {
        BlockEntity transferTo = this.m_58904_().m_7702_(this.m_58899_().m_121945_(dir));
        if (transferTo != null) {
            return transferTo.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).resolve();
        }
        return Optional.empty();
    }

    public void setTypeFilters(byte[] typeFilters) {
        this.typeFilters = typeFilters;
        this.m_6596_();
    }

    public void setTypeFilters(int index, byte value) {
        this.typeFilters[index] = value;
        this.m_6596_();
    }

    public byte[] getTypeFilters() {
        return this.typeFilters;
    }

    public void setSpeciesFilters(String[] speciesFilters) {
        if (speciesFilters.length != 36) {
            ComplicatedBees.LOGGER.error("tried to set species filter on bee sorter with incorrect array size at position {}", (Object)this.m_58899_());
            return;
        }
        this.speciesFilters = speciesFilters;
        this.m_6596_();
    }

    public String[] getSpeciesFilters() {
        return this.speciesFilters;
    }

    private boolean testFilter(int index, ItemStack stack) {
        return switch (this.typeFilters[index]) {
            case 1 -> stack.m_150930_((Item)ItemsRegistration.DRONE.get());
            case 2 -> stack.m_150930_((Item)ItemsRegistration.PRINCESS.get());
            case 3 -> stack.m_150930_((Item)ItemsRegistration.QUEEN.get());
            case 4 -> stack.m_204117_(ItemTagGenerator.BEE);
            case 5 -> {
                if (!stack.m_204117_(ItemTagGenerator.BEE)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private LazyOptional<IItemHandler> createFilterHandler(final int index) {
        return LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.item){

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (BeeSorterBlockEntity.this.filterSpecificity(Direction.values()[index]) > 0) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }
        });
    }

    private boolean matchFilter(String species, String filter) {
        return Objects.equals(species, filter) || filter.isEmpty();
    }

    private int filterSpecificity(Direction dir) {
        int level = 0;
        ItemStack stack = this.item.getStackInSlot(0);
        if (!stack.m_41619_() & this.testFilter(dir.ordinal(), stack)) {
            if (!this.hasFilters(dir)) {
                return 1;
            }
            for (int i = 0; i < 3; ++i) {
                String primarySpeciesFilter = this.speciesFilters[dir.ordinal() * 6 + i * 2];
                String secondarySpeciesFilter = this.speciesFilters[dir.ordinal() * 6 + i * 2 + 1];
                String primarySpecies = GeneticHelper.getRaw(stack, GeneSpecies.ID, true).m_128461_("data");
                String secondarySpecies = GeneticHelper.getRaw(stack, GeneSpecies.ID, false).m_128461_("data");
                if (primarySpecies.isEmpty() || secondarySpecies.isEmpty()) {
                    ComplicatedBees.LOGGER.error("tried filtering item with missing species tag at pos {}", (Object)this.m_58899_());
                    break;
                }
                if (!(this.matchFilter(primarySpecies, primarySpeciesFilter) & this.matchFilter(secondarySpecies, secondarySpeciesFilter))) continue;
                if (primarySpeciesFilter.isEmpty() ^ secondarySpeciesFilter.isEmpty()) {
                    level = Math.max(2, level);
                    continue;
                }
                if (!(!primarySpeciesFilter.isEmpty() & !secondarySpeciesFilter.isEmpty())) continue;
                return 3;
            }
        }
        return level;
    }

    private boolean hasFilters(Direction dir) {
        return !(this.speciesFilters[dir.ordinal() * 6].isEmpty() & this.speciesFilters[dir.ordinal() * 6 + 1].isEmpty() & this.speciesFilters[dir.ordinal() * 6 + 2].isEmpty() & this.speciesFilters[dir.ordinal() * 6 + 3].isEmpty() & this.speciesFilters[dir.ordinal() * 6 + 4].isEmpty() & this.speciesFilters[dir.ordinal() * 6 + 5].isEmpty());
    }

    public ItemStackHandler getItem() {
        return this.item;
    }
}

