/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.block.entity.AbstractCentrifugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.AdaptedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.item.UpgradeItem;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.util.UpgradeHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class CentrifugeBlockEntity
extends AbstractCentrifugeBlockEntity {
    public static final String ENERGY_TAG = "energy";
    public static final int INPUT_SLOT_COUNT = 1;
    public static final int OUTPUT_SLOT_COUNT = 9;
    public static final int UPGRADE_SLOT_COUNT = 3;
    public static final int SLOT_COUNT = 13;
    public static final int CAPACITY = 100000;
    public static final int BASE_USAGE = (Integer)ServerConfig.SERVER_CONFIG.centrifugeBaseEnergy.get();
    public static final int BASE_MAX_PROGRESS = (Integer)ServerConfig.SERVER_CONFIG.centrifugeBaseSpeed.get();
    private final LazyOptional<IItemHandler> inputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.inputItems){

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    });
    private final LazyOptional<IItemHandler> outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

        @Override
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    });
    public final LazyOptional<IItemHandler> upgradeItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.upgradeItems){

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof UpgradeItem;
        }
    });
    private final LazyOptional<IItemHandler> itemHandler;
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage(this.energyStorage){

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            CentrifugeBlockEntity.this.m_6596_();
            return super.receiveEnergy(maxReceive, simulate);
        }

        @Override
        public boolean canExtract() {
            return false;
        }

        @Override
        public boolean canReceive() {
            return true;
        }
    });

    public CentrifugeBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntitiesRegistration.CENTRIFUGE_ENTITY.get(), pos, blockState);
        this.itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.outputItemHandler.resolve().get(), (IItemHandlerModifiable)this.inputItemHandler.resolve().get()}));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.getProgress() > 0) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
        } else {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public int getStoredPower() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ENERGY_TAG, ((EnergyStorage)this.energyStorage).serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ENERGY_TAG)) {
            ((EnergyStorage)this.energyStorage).deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
    }

    @Override
    public List<ItemStack> getCurrentlyProcessing() {
        ItemStack stack = this.inputItems.getStackInSlot(0);
        if (this.getRecipe(stack) != null) {
            return List.of(stack);
        }
        return List.of();
    }

    @Override
    protected ItemStackHandler createInputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                CentrifugeBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return CentrifugeBlockEntity.this.getRecipe(stack) != null;
            }
        };
    }

    @Override
    protected ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                CentrifugeBlockEntity.this.m_6596_();
            }
        };
    }

    @Override
    protected ItemStackHandler createUpgradeHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                CentrifugeBlockEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected EnergyStorage createEnergyStorage() {
        return new EnergyStorage(100000);
    }

    @Override
    public int getMaxProgress() {
        this.setMaxProgress(Math.round((float)BASE_MAX_PROGRESS / UpgradeHelper.getSpeedMod((IItemHandler)this.upgradeItems)));
        return super.getMaxProgress();
    }

    @Override
    public int getActiveEnergyUsage() {
        this.setActiveEnergyUsage(Math.round((float)BASE_USAGE / UpgradeHelper.getEfficiencyMod((IItemHandler)this.upgradeItems)));
        return super.getActiveEnergyUsage();
    }

    @Override
    public int getEnergyUsage() {
        return this.getIdleEnergyUsage() + (this.isCrafting() ? this.getActiveEnergyUsage() : 0);
    }

    @Override
    public void setEnergyUsage(int value) {
        super.setEnergyUsage(this.getEnergyUsage());
    }

    @Override
    public float getOutputMod() {
        return UpgradeHelper.getOutputMod((IItemHandler)this.upgradeItems);
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getInputItemHandler() {
        return this.inputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getOutputItemHandler() {
        return this.outputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getUpgradeItemHandler() {
        return this.upgradeItemHandler;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public ItemStackHandler getInputItems() {
        return this.inputItems;
    }
}

