/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.gyrofuge;

import com.accbdd.complicated_bees.bees.MachineModifier;
import com.accbdd.complicated_bees.block.entity.AbstractCentrifugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.AdaptedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.gyrofuge.IGyrofugeTickable;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.item.UpgradeItem;
import com.accbdd.complicated_bees.multiblock.GyrofugeLogic;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.util.MultiblockHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class GyrofugeControllerBlockEntity
extends AbstractCentrifugeBlockEntity {
    public static final int INPUT_SLOT_COUNT = 4;
    public static final int OUTPUT_SLOT_COUNT = 9;
    public static final int UPGRADE_SLOT_COUNT = 0;
    public static final int SLOT_COUNT = 13;
    private GyrofugeLogic gyrofugeLogic;
    private MachineModifier modifier = MachineModifier.BLANK;
    public static final int BASE_USAGE = (Integer)ServerConfig.SERVER_CONFIG.gyrofugeBaseUsage.get();
    public static final int BASE_IDLE_USAGE = (Integer)ServerConfig.SERVER_CONFIG.gyrofugeBaseIdleUsage.get();
    public static final int BASE_MAX_PROGRESS = (Integer)ServerConfig.SERVER_CONFIG.gyrofugeBaseSpeed.get();
    private final LazyOptional<IItemHandler> inputItemHandler;
    private final LazyOptional<IItemHandler> outputItemHandler;
    public final LazyOptional<IItemHandler> upgradeItemHandler;
    private final LazyOptional<IItemHandler> itemHandler;
    private final LazyOptional<IEnergyStorage> energyHandler;

    public GyrofugeControllerBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntitiesRegistration.GYROFUGE_CONTROLLER_BLOCK_ENTITY.get(), pos, blockState);
        this.setActiveEnergyUsage(BASE_USAGE);
        this.inputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.inputItems){

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }
        });
        this.outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

            @Override
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }

            @Override
            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }
        });
        this.upgradeItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.upgradeItems){

            @Override
            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof UpgradeItem;
            }
        });
        this.energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage(this.getGyrofugeLogic().getEnergyStorage()));
        this.itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.outputItemHandler.resolve().get(), (IItemHandlerModifiable)this.inputItemHandler.resolve().get()}));
    }

    @Override
    public ContainerData getData() {
        return super.getData();
    }

    public void setLogic(GyrofugeLogic logic) {
        this.gyrofugeLogic = logic;
        this.modifier = logic.getMachineModifier();
        this.setActiveEnergyUsage(Math.round((float)BASE_USAGE / this.modifier.getEfficiencyMod()));
        this.setIdleEnergyUsage(BASE_IDLE_USAGE + this.gyrofugeLogic.getIdleUsage());
        this.energyStorage = this.gyrofugeLogic.getEnergyStorage();
    }

    public GyrofugeLogic getGyrofugeLogic() {
        if (this.gyrofugeLogic == null && MultiblockHelper.isValidGyrofuge(this.m_58904_(), this.m_58899_())) {
            MultiblockHelper.buildGyrofuge(this.m_58904_(), this.m_58899_());
        }
        return this.gyrofugeLogic;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.getGyrofugeLogic().getSpecialBlocks().stream().forEach(pos -> {
            BlockEntity patt4726$temp = this.m_58904_().m_7702_(pos);
            if (patt4726$temp instanceof IGyrofugeTickable) {
                IGyrofugeTickable tickable = (IGyrofugeTickable)patt4726$temp;
                tickable.onTick();
            }
        });
    }

    @Override
    protected ItemStackHandler createInputHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                GyrofugeControllerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return GyrofugeControllerBlockEntity.this.getRecipe(stack) != null;
            }
        };
    }

    @Override
    protected ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                GyrofugeControllerBlockEntity.this.m_6596_();
            }
        };
    }

    @Override
    protected ItemStackHandler createUpgradeHandler() {
        return new ItemStackHandler(0);
    }

    @Override
    protected EnergyStorage createEnergyStorage() {
        return new EnergyStorage(0);
    }

    @Override
    public List<ItemStack> getCurrentlyProcessing() {
        ArrayList<ItemStack> toProcess = new ArrayList<ItemStack>();
        int processed = 0;
        for (int i = 0; i < this.inputItems.getSlots(); ++i) {
            ItemStack stack = this.inputItems.getStackInSlot(i);
            if (this.getRecipe(stack) == null) continue;
            int stackProcessed = 0;
            while (processed < this.modifier.getProcessingMod() + 1 && stack.m_41613_() - stackProcessed > 0) {
                toProcess.add(stack);
                ++stackProcessed;
                ++processed;
            }
        }
        return toProcess;
    }

    @Override
    public float getOutputMod() {
        return this.modifier.getOutputMod();
    }

    @Override
    public int getMaxProgress() {
        return Math.round((float)BASE_MAX_PROGRESS / this.modifier.getSpeedMod());
    }

    @Override
    public int getActiveEnergyUsage() {
        if (this.modifier == null) {
            this.modifier = MachineModifier.BLANK;
        }
        return super.getActiveEnergyUsage();
    }

    @Override
    public int getEnergyUsage() {
        return this.getIdleEnergyUsage() + (this.isCrafting() ? this.getActiveEnergyUsage() : 0);
    }

    @Override
    public void setEnergyUsage(int value) {
        super.setEnergyUsage(this.getEnergyUsage());
    }

    @Override
    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getInputItemHandler() {
        return this.inputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getOutputItemHandler() {
        return this.outputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandler> getUpgradeItemHandler() {
        return this.upgradeItemHandler;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public ItemStackHandler getInputItems() {
        return this.inputItems;
    }
}

