/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.gyrofuge;

import com.accbdd.complicated_bees.block.entity.gyrofuge.AbstractGyrofugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.IGyrofugeTickable;
import com.accbdd.complicated_bees.multiblock.GyrofugeLogic;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class GyrofugeOutputHatchBlockEntity
extends AbstractGyrofugeBlockEntity
implements IGyrofugeTickable {
    private LazyOptional<IItemHandler> gyrofugeOutput;
    private int tickCount;

    public GyrofugeOutputHatchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.GYROFUGE_OUTPUT_HATCH_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    public void setLogic(GyrofugeLogic logic) {
        super.setLogic(logic);
        this.gyrofugeOutput = logic != null ? logic.getController().getOutputItemHandler() : null;
    }

    @Override
    public void onTick() {
        if (this.gyrofugeOutput != null && this.tickCount++ % 4 == 0) {
            for (Direction dir : Direction.values()) {
                BlockEntity blockEntity = this.m_58904_().m_7702_(this.m_58899_().m_121945_(dir));
                if (blockEntity == null || blockEntity instanceof AbstractGyrofugeBlockEntity) continue;
                IItemHandler itemCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).resolve().orElse(null);
                IItemHandler output = this.gyrofugeOutput.resolve().orElse(null);
                if (itemCap == null || output == null) continue;
                Util.moveInventoryItems(output, itemCap);
            }
            this.tickCount = 0;
        }
    }
}

